//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "AnimationProperties.h"

namespace Courier { 

// ------------------------------------------------------------------------
AnimationProperties::AnimationProperties() : 
    mSpeedFactor(1.0F), mRepeatCount(1), mTimeToFinish(0), 
    mSequenceStartTimeMs(0),mSequenceDurationMs(1000),
    mRepeatMode(Candera::Animation::AnimationPlayer::Replay), mPlayDirection(Candera::Animation::AnimationPlayer::Forward)
{
    mWasSet.mPlayDirection = (false);
    mWasSet.mRepeatCount = (false);
    mWasSet.mRepeatMode = (false);
    mWasSet.mSequenceDurationMs = (false);
    mWasSet.mSequenceStartTimeMs = (false); 
    mWasSet.mSpeedFactor = (false);
}

// ------------------------------------------------------------------------
AnimationProperties::AnimationProperties(const AnimationProperties & properties) :
    mSpeedFactor(properties.mSpeedFactor),
    mRepeatCount(properties.mRepeatCount), 
    mTimeToFinish(properties.mTimeToFinish), 
    mSequenceStartTimeMs(properties.mSequenceStartTimeMs),
    mSequenceDurationMs(properties.mSequenceDurationMs),
    mRepeatMode(properties.mRepeatMode), 
    mPlayDirection(properties.mPlayDirection), 
    mWasSet(properties.mWasSet)
{
}

// ------------------------------------------------------------------------
void AnimationProperties::ApplyProperties(Candera::Animation::AnimationPlayer * singlePlayer) const 
{
    if(singlePlayer!=0) {
        if(static_cast<bool>(mWasSet.mSequenceStartTimeMs)) {
            singlePlayer->SetSequenceStartTimeMs(mSequenceStartTimeMs);
        }
        if(static_cast<bool>(mWasSet.mSequenceDurationMs)) {
            singlePlayer->SetSequenceDurationMs(mSequenceDurationMs);
        }
        if(static_cast<bool>(mWasSet.mRepeatMode)) {
            singlePlayer->SetRepeatMode(mRepeatMode);
        }
        if (static_cast<bool>(mWasSet.mRepeatCount)) {
            singlePlayer->SetRepeatCount(mRepeatCount);
        }
        if(static_cast<bool>(mWasSet.mPlayDirection)) {
            singlePlayer->SetDirection(mPlayDirection);
        }
        if(static_cast<bool>(mWasSet.mSpeedFactor)) {
            singlePlayer->SetSpeedFactor(mSpeedFactor);
        }
    }
}

// ------------------------------------------------------------------------
void AnimationProperties::ApplyProperties(Candera::Animation::AnimationPlayerBase * animationPlayerBase) const 
{
    if(animationPlayerBase!=0) {
        if(static_cast<bool>(mWasSet.mSpeedFactor)) {
            animationPlayerBase->SetSpeedFactor(mSpeedFactor);
        }
        if(static_cast<bool>(mWasSet.mRepeatCount)) {
            animationPlayerBase->SetRepeatCount(mRepeatCount);
        }
    }
}

}

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {

template<> UInt32 StringBufferAppender< Candera::Animation::AnimationPlayer::PlayDirection >::Append(StringBuffer& stringBuffer, Candera::Animation::AnimationPlayer::PlayDirection const & object)
{
    UInt32 tcharCount = 0;
    switch (object) {
    case ::Candera::Animation::AnimationPlayer::Forward:
        tcharCount += stringBuffer.Append("::Candera::AnimationPlayer::Forward");
        break;
    case ::Candera::Animation::AnimationPlayer::Reverse:
        tcharCount += stringBuffer.Append("::Candera::AnimationPlayer::Reverse");
        break;
    default:
        tcharCount += stringBuffer.Append("##unknown##");
        break;
    }
    return tcharCount;
}

template<> UInt32 StringBufferAppender< Candera::Animation::AnimationPlayer::RepeatMode >::Append(StringBuffer& stringBuffer, Candera::Animation::AnimationPlayer::RepeatMode const & object)
{
    UInt32 tcharCount = 0;
    switch (object) {
    case ::Candera::Animation::AnimationPlayer::Replay:
        tcharCount += stringBuffer.Append("::Candera::AnimationPlayer::Replay");
        break;
    case ::Candera::Animation::AnimationPlayer::Bounce:
        tcharCount += stringBuffer.Append("::Candera::AnimationPlayer::Bounce");
        break;
    default:
        tcharCount += stringBuffer.Append("##unknown##");
        break;
    }
    return tcharCount;
}

template<> UInt32 StringBufferAppender< Courier::AnimationProperties >::Append(StringBuffer& stringBuffer, Courier::AnimationProperties const & object)
{
    ::FeatStd::UInt32 tcharCount = 0;
    tcharCount += stringBuffer.Append("Courier::AnimationProperties { TimeToFinish = ");
    tcharCount += stringBuffer.AppendObject(object.mTimeToFinish);
    if (object.mWasSet.mSpeedFactor) {
        tcharCount += stringBuffer.Append(", SpeedFactor = ");
        tcharCount += stringBuffer.AppendObject(object.mSpeedFactor);
    }
    if (object.mWasSet.mRepeatCount) {
        tcharCount += stringBuffer.Append(", RepeatCount = ");
        tcharCount += stringBuffer.AppendObject(object.mRepeatCount);
    }
    if (object.mWasSet.mSequenceStartTimeMs) {
        tcharCount += stringBuffer.Append(", SequenceStartTimeMs = ");
        tcharCount += stringBuffer.AppendObject(object.mSequenceStartTimeMs);
    }
    if (object.mWasSet.mSequenceDurationMs) {
        tcharCount += stringBuffer.Append(", SequenceDurationMs = ");
        tcharCount += stringBuffer.AppendObject(object.mSequenceDurationMs);
    }
    if (object.mWasSet.mRepeatMode) {
        tcharCount += stringBuffer.Append(", RepeatMode = ");
        tcharCount += stringBuffer.AppendObject(object.mRepeatMode);
    }
    if (object.mWasSet.mPlayDirection) {
        tcharCount += stringBuffer.Append(", PlayDirection = ");
        tcharCount += stringBuffer.AppendObject(object.mPlayDirection);
    }
    tcharCount += stringBuffer.Append(" }");
    return tcharCount;
}

}
#endif
