//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Util_Traits_h)
#define Courier_Util_Traits_h

#include <Courier/Base.h>
#include <FeatStd/Util/Traits.h>

/// @addtogroup COURIER_UTIL
/// @{

namespace Courier { namespace Internal { 

    using FeatStd::Internal::ArrayTrait;
    using FeatStd::Internal::ArrayItemCount;


    using FeatStd::Internal::PointerTrait;

    using FeatStd::Internal::ReferenceTrait;

    using FeatStd::Internal::LogicalAnd;
    using FeatStd::Internal::LogicalOr;
    using FeatStd::Internal::LogicalNot;

    using FeatStd::Internal::MakeUnsigned;
    using FeatStd::Internal::MakeSigned;

    using FeatStd::Internal::IsSigned;
    using FeatStd::Internal::IsUnsigned;

    using FeatStd::Internal::TypeName;

    using FeatStd::Internal::IsIntegral;
    using FeatStd::Internal::IsFloatingPoint;
    using FeatStd::Internal::ArgType;

    using FeatStd::Internal::VolatileRemover;
    using FeatStd::Internal::ConstRemover;
    using FeatStd::Internal::QualifierRemover;
    using FeatStd::Internal::PureType;

    using FeatStd::Internal::IsDerivedFrom;
    using FeatStd::Internal::IsAbstract;

    using FeatStd::Internal::TypeEqual;

}}   // namespace


/** use this macro in global scope to enable debugging output of custom types names 
    @param type any type */
#define COURIER_DEF_TYPE_NAME(type) FEATSTD_DEF_TYPE_NAME(type)

/// @}

#endif // Courier_Util_Traits_h
