//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "BitTools.h"

namespace Courier { namespace Internal {

    // ------------------------------------------------------------------------
    UInt32 CountLeadingZeros(UInt32 v) 
    {
        // source Hackers Delight, Chapter 5-3 Counting Leading 0's
        UInt32 c;
        if ((v & 0x1U) == 0)  {
            c = 1;
            if ((v & 0x0000ffffU) == 0) {
                v >>= 16;
                c += 16;
            }
            if ((v & 0x000000ffU) == 0) {
                v >>= 8;
                c += 8;
            }
            if ((v & 0x0000000fU) == 0) {
                v >>= 4;
                c += 4;
            }
            if ((v & 0x00000003U) == 0) {
                v >>= 2;
                c += 2;
            }
            c -= (v & 0x1U);
        }
        else {
            c = 0;
        }
        return c;
    }


}}
