//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Util_BinarySearch_h)
#define Courier_Util_BinarySearch_h

#include <Courier/Base.h>

namespace Courier {
    /// @addtogroup COURIER_UTIL
    /// @{
    /** implements binary search algorithm
        @param key the value to search
        @param it a random access iterator
        @param nItems the number of items in the collection the iterator refers to
        @return the iterator to the key item or null of key is not in the collection */
    template<typename Key, typename It> It BinarySearch(Key key, It it, UInt32 nItems) {
#if defined(FEATSTD_DEBUG)
        It dbgLast = it + nItems;
#endif
        It mid = 0;
        for (;;) {
            if (nItems == 0) {
                mid = 0;
                break;
            }

            UInt32 n = nItems / 2;
            mid = it + n;
#if defined(FEATSTD_DEBUG)
            FEATSTD_DEBUG_ASSERT(mid != dbgLast);
#endif
            if (key == *mid) {
                break;
            }
            if (key < *mid) {
                nItems = n;
            }
            else {
                it = mid + 1;
                nItems -= (n + 1);
            }
        }
        return mid;
    }

    /** implements binary search algorithm
        @param key the value to search
        @param it a random access iterator
        @param nItems the number of items in the collection the iterator refers to
        @param Pred predicate functions - returns 0 if given key matches the iterator,
                    value < 0 if key is smaller, value > 0 if key is larger iterator
                    referenced collection member (similar to str cmp)
        @return the iterator to the key item or null of key is not in the collection */
    template<typename Key, typename It, typename ItRefType> It BinarySearch(Key key, It it, UInt32 nItems, Int(*Pred)(Key, ItRefType)) {
        It mid = 0;
        for (;;) {
            if (nItems == 0) {
                mid = 0;
                break;
            }

            UInt32 n = nItems / 2;
            mid = it + n;

            Int rc = Pred(key, *mid);
            if (rc == 0) {
                break;
            }
            if (rc < 0) {
                nItems = n;
            }
            else {
                it = mid + 1;
                nItems -= (n + 1);
            }
        }
        return mid;
    }

    /// @}
}

#endif
