//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(Courier_TransitionMsgs_h)
#define Courier_TransitionMsgs_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
#include <Courier/Serialization/BaseSerializer.h>
#endif
#include <Courier/Messaging/Message.h>
#include <Courier/Transitions/TransitionTypes.h>
#include <CanderaTransitions/Transition.h>
#include <Courier/Transitions/TransitionStringBufferAppenders.h>

namespace Courier {
// ------------------------------------------------------------------------
/// @addtogroup COURIER_TRANSITION_MESSAGES
/// @{
              /** Message use to create transition request fragments (Activate, Deactivate, Finish).
              *   - RequestAction: specifies the action for the request fragment. Can be Activate, Deactivate or Finish. Also refer to Candera::Transition::Request;
              *   - RequestIdentifier: refer to Candera::Transitions::Identifier;
              *   - RequestHint: refer to Candera::Transitions::Hint.
              */
class CanderaTransitionRequestMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CanderaTransitionRequestMsg, ::Courier::Message, 0x6CA6C3E4);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        CanderaTransitionRequestMsg();
        CanderaTransitionRequestMsg(Courier::CanderaTransitionRequestAction::Enum const & aRequestAction, Candera::Transitions::Identifier const & aRequestIdentifier, Candera::Transitions::Hint const & aRequestHint);
        virtual ~CanderaTransitionRequestMsg();

        Courier::CanderaTransitionRequestAction::Enum const & GetRequestAction() const { return mRequestAction; }
        void SetRequestAction(Courier::CanderaTransitionRequestAction::Enum const & value) { mRequestAction = value; }
        Candera::Transitions::Identifier const & GetRequestIdentifier() const { return mRequestIdentifier; }
        void SetRequestIdentifier(Candera::Transitions::Identifier const & value) { mRequestIdentifier = value; }
        Candera::Transitions::Hint const & GetRequestHint() const { return mRequestHint; }
        void SetRequestHint(Candera::Transitions::Hint const & value) { mRequestHint = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCanderaTransitionRequestMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCanderaTransitionRequestMsgModifiableMetadata;
        static const ::Courier::ComponentId mCanderaTransitionRequestMsgSubscriberList[];

        Courier::CanderaTransitionRequestAction::Enum mRequestAction;
        Candera::Transitions::Identifier mRequestIdentifier;
        Candera::Transitions::Hint mRequestHint;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_TRANSITION_MESSAGES
/// @{
              /** Response message for CanderaTransitionRequestMsg.
              *   - RequestAction: specifies the action for the request fragment. Can be Activate, Deactivate or Finish. Also refer to Candera::Transition::Request;
              *   - Success: indicates if the creation of the transition request fragment  was successful or not.
              */
class CanderaTransitionResponseMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CanderaTransitionResponseMsg, ::Courier::Message, 0x6CF10C8D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        CanderaTransitionResponseMsg();
        CanderaTransitionResponseMsg(Courier::CanderaTransitionRequestAction::Enum const & aRequestAction, bool const & aSuccess);
        virtual ~CanderaTransitionResponseMsg();

        Courier::CanderaTransitionRequestAction::Enum const & GetRequestAction() const { return mRequestAction; }
        void SetRequestAction(Courier::CanderaTransitionRequestAction::Enum const & value) { mRequestAction = value; }
        bool const & GetSuccess() const { return mSuccess; }
        void SetSuccess(bool const & value) { mSuccess = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCanderaTransitionResponseMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCanderaTransitionResponseMsgModifiableMetadata;
        static ::Courier::ComponentId mCanderaTransitionResponseMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        Courier::CanderaTransitionRequestAction::Enum mRequestAction;
        bool mSuccess;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_TRANSITION_MESSAGES
/// @{
          /** Message for indicating beginning or ending composing a request.
          *    CanderaTransitionRequestMsg must be sent to add corresponding request fragments to the transition request.
          *   - ControlFlowAction: Can be Begin or End. Also refer to Candera::Transition::Request for more details.
          */
class CanderaTransitionControlFlowReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CanderaTransitionControlFlowReqMsg, ::Courier::Message, 0x37299B2F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        CanderaTransitionControlFlowReqMsg();
        CanderaTransitionControlFlowReqMsg(Courier::CanderaTransitionControlFlowAction::Enum const & aControlFlowAction);
        virtual ~CanderaTransitionControlFlowReqMsg();

        Courier::CanderaTransitionControlFlowAction::Enum const & GetControlFlowAction() const { return mControlFlowAction; }
        void SetControlFlowAction(Courier::CanderaTransitionControlFlowAction::Enum const & value) { mControlFlowAction = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCanderaTransitionControlFlowReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCanderaTransitionControlFlowReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mCanderaTransitionControlFlowReqMsgSubscriberList[];

        Courier::CanderaTransitionControlFlowAction::Enum mControlFlowAction;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_TRANSITION_MESSAGES
/// @{
          /** Response message for CanderaTransitionRequestMsg.
          *   - ControlFlowAction:  Can be Begin or End. Also refer to Candera::Transition::Request for more details;
          *   - Success: indicates if the ControlFlowAction was successful or not.
          */
class CanderaTransitionControlFlowResMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CanderaTransitionControlFlowResMsg, ::Courier::Message, 0xA33412C6);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        CanderaTransitionControlFlowResMsg();
        CanderaTransitionControlFlowResMsg(Courier::CanderaTransitionControlFlowAction::Enum const & aControlFlowAction, bool const & aSuccess);
        virtual ~CanderaTransitionControlFlowResMsg();

        Courier::CanderaTransitionControlFlowAction::Enum const & GetControlFlowAction() const { return mControlFlowAction; }
        void SetControlFlowAction(Courier::CanderaTransitionControlFlowAction::Enum const & value) { mControlFlowAction = value; }
        bool const & GetSuccess() const { return mSuccess; }
        void SetSuccess(bool const & value) { mSuccess = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCanderaTransitionControlFlowResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCanderaTransitionControlFlowResMsgModifiableMetadata;
        static const ::Courier::ComponentId mCanderaTransitionControlFlowResMsgSubscriberList[];

        Courier::CanderaTransitionControlFlowAction::Enum mControlFlowAction;
        bool mSuccess;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_TRANSITION_MESSAGES
/// @{
          /** Message which is sent to indicate the transition events.
          *   - TransitionEventType: can be one of the following:
          *     - CanderaTransitionEventType::OnStartTransitionEvent;
          *     - CanderaTransitionEventType::OnFinishTransitionEvent;
          *     Please refer to the Candera::Transitions events for more details.
          *   - TransitionPtr: share pointer to the transition for which the event is sent.
          */
class CanderaTransitionIndMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CanderaTransitionIndMsg, ::Courier::Message, 0xBBD0E432);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        CanderaTransitionIndMsg();
        CanderaTransitionIndMsg(Courier::CanderaTransitionEventType::Enum const & aTransitionEventType, Candera::Transitions::Transition::SharedPointer const & aTransitionPtr);
        virtual ~CanderaTransitionIndMsg();

        Courier::CanderaTransitionEventType::Enum const & GetTransitionEventType() const { return mTransitionEventType; }
        void SetTransitionEventType(Courier::CanderaTransitionEventType::Enum const & value) { mTransitionEventType = value; }
        Candera::Transitions::Transition::SharedPointer const & GetTransitionPtr() const { return mTransitionPtr; }
        void SetTransitionPtr(Candera::Transitions::Transition::SharedPointer const & value) { mTransitionPtr = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCanderaTransitionIndMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCanderaTransitionIndMsgModifiableMetadata;
        static ::Courier::ComponentId mCanderaTransitionIndMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        Courier::CanderaTransitionEventType::Enum mTransitionEventType;
        Candera::Transitions::Transition::SharedPointer mTransitionPtr;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_TRANSITION_MESSAGES
/// @{
          /** Message which is sent to indicate the transition fragment events.
          *   - TransitionFragmentEventType: can be one of the following:
          *     - CanderaTransitionEventType::OnStartTransitionFragmentEvent;
          *     - CanderaTransitionEventType::OnFinishTransitionFragmentEvent.
          *     Please refer to the Candera::Transitions events for more details.
          *   - TransitionFragmentPtr: share pointer to the transition fragment for which the event is sent.
          */
class CanderaTransitionFragmentIndMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CanderaTransitionFragmentIndMsg, ::Courier::Message, 0x9859373B);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        CanderaTransitionFragmentIndMsg();
        CanderaTransitionFragmentIndMsg(Courier::CanderaTransitionEventType::Enum const & aTransitionFragmentEventType, Candera::Transitions::TransitionFragment::SharedPointer const & aTransitionFragmentPtr);
        virtual ~CanderaTransitionFragmentIndMsg();

        Courier::CanderaTransitionEventType::Enum const & GetTransitionFragmentEventType() const { return mTransitionFragmentEventType; }
        void SetTransitionFragmentEventType(Courier::CanderaTransitionEventType::Enum const & value) { mTransitionFragmentEventType = value; }
        Candera::Transitions::TransitionFragment::SharedPointer const & GetTransitionFragmentPtr() const { return mTransitionFragmentPtr; }
        void SetTransitionFragmentPtr(Candera::Transitions::TransitionFragment::SharedPointer const & value) { mTransitionFragmentPtr = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCanderaTransitionFragmentIndMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCanderaTransitionFragmentIndMsgModifiableMetadata;
        static const ::Courier::ComponentId mCanderaTransitionFragmentIndMsgSubscriberList[];

        Courier::CanderaTransitionEventType::Enum mTransitionFragmentEventType;
        Candera::Transitions::TransitionFragment::SharedPointer mTransitionFragmentPtr;
};

/// @}
} // namespace Courier
#endif // Courier_TransitionMsgs_h
