//########################################################################
// (C) Candera GmbH
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Candera GmbH.
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_CanderaTransitionHandler_h)
#define Courier_CanderaTransitionHandler_h

#include <Courier/Util/Util.h>
#include <Courier/Platform/MessageFactory.h>
#include <Courier/Visualization/IViewHandler.h>

#include <CanderaTransitions/Identifier.h>
#include <CanderaTransitions/Hint.h>
#include <CanderaTransitions/Request.h>
#include <CanderaTransitions/TransitionEvents.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProvider.h>
#include <FeatStd/Container/Vector.h>

#include "TransitionMsgs.h"
#include <Courier/Visualization/ViewScene.h>

namespace Courier {
namespace Internal {
/// @addtogroup COURIER_VISUALIZATION
/// @{
/** The CanderaTransitionHandler creates concrete Candera::Transitions::Request sets based on the dedicated courier messages.
*/
class CanderaTransitionHandler
{
public:
    ///
    CanderaTransitionHandler();

    ///
    virtual ~CanderaTransitionHandler();

    void Init(IViewHandler * viewHandler, Candera::DefaultAssetProvider* assetProvider);

    ///
    void SetAnimationTimeDispatcher(Candera::Animation::AnimationTimeDispatcher::SharedPointer timeDispatcher) const;

    ///
    Candera::Animation::AnimationTimeDispatcher::SharedPointer GetAnimationTimeDispatcher() const;

    ///
    bool SetTransitionRuleSet(const Candera::Transitions::Rule::Set::SharedPointer& ruleSet);
    ///
    void CreateTransitionRequestFragment(CanderaTransitionRequestAction::Enum action,
                                            const Candera::Transitions::Identifier& identifier,
                                            const Candera::Transitions::Hint& hint);
    ///
    void CreateControlFlowRequest(CanderaTransitionControlFlowAction::Enum action);

    ///
    void Update(Candera::TimeType deltaTime) const;

    void InvalidateTransitionViews();
    bool IsInvalidateAll() const { return mInvalidateAll; }

    bool IsCanderaTransitionOngoing() const { return mTransitionOngoing; }

    static void SetMessagingTransitionDeactivationHandler(ViewScene::MessagingTransitionDeactivationHandler messagingDeactivationHandler);

private:
    Candera::Transitions::Rule::Set::SharedPointer mRuleSet;
    Candera::Transitions::Transition::Set mTrSet;
    Candera::Transitions::Request::Handle mReqHandle;

    class CanderaTransitionEventListener: public Candera::EventListener
    {
    public:
        CanderaTransitionEventListener() :
            mCanderaTransitionHandler(0)
        {
        }

        void Init(CanderaTransitionHandler* canderaTransitionHandler)
        {
            mCanderaTransitionHandler = canderaTransitionHandler;
        }

        virtual Candera::EventListener::EventStatus OnEvent(const Candera::Event& event);

    private:
        CanderaTransitionHandler* mCanderaTransitionHandler;
    };

    Candera::EventListener::EventStatus OnEvent(const Candera::Event& event);
    void AddView(const Candera::Transitions::Identifier& identifier);

    CanderaTransitionEventListener mTrEventListener;
    Candera::DefaultAssetProvider* mAssetProvider;
    IViewHandler* mViewHandler;
    FeatStd::Internal::Vector<View*> mTransitionViewsVct;
    bool mInvalidateAll;
    bool mTransitionOngoing;
};
}
/// @}
}

#endif
