//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Platform_Types_h)
#define Courier_Platform_Types_h

#include <Courier/Config.h>
#include <FeatStd/Platform/Types.h>

///
namespace Courier { 
    ///
    namespace Platform {
    /// @addtogroup COURIER_PLATFORM
    /// @{
    namespace Types {
        /** Character data type.
            Char data stores a single 8 bit character. */
        using FeatStd::Char;

        /** UCS2 data type. */
        using FeatStd::Ucs2Char;

        /** Character type for I18N text */
        using FeatStd::TChar;

        /** Defines the encoding of TChar strings */
        using FeatStd::TCharEncodingScheme;

        /** Defines the encoding of TChar is UTF */
        using FeatStd::TCharIsUtfEncoded;

        /** Integer data type.
            Int data stores signed integral data with architecture dependent bit size.
            Int shall at least store 16 bit data. */
        using FeatStd::Int;

        /** Unsigned integer data type.
            UInt data stores unsigned integral data with architecture dependent bit size.
            UInt shall at least store 16 bit data.
            The return value of the sizeof() operator (size_t) is defined as UInt. */
        using FeatStd::UInt;

        /** 8bit signed integer data type.
            Int8 data stores signed 8 bit integral data. */
        using FeatStd::Int8;

        /** 8bit unsigned integer data type.
            UInt8 data stores unsigned 8 bit integral data. */
        using FeatStd::UInt8;

        /** 16bit signed integer data type.
            Int16 data stores signed 16 bit integral data. */
        using FeatStd::Int16;

        /** 16bit unsigned integer data type.
            UInt16 data stores unsigned 16 bit integral data. */
        using FeatStd::UInt16;

        /** 32bit signed integer data type.
            Int32 data stores signed 32 bit integral data. */
        using FeatStd::Int32;

        /** 32bit unsigned integer data type.
            UInt32 data stores signed 32 bit integral data. */
        using FeatStd::UInt32;

        /** 64bit signed integer data type.
            Int64 data stores signed 64 bit integral data. */
        using FeatStd::Int64;

        /** 64bit unsigned integer data type.
            UInt64 data stores unsigned 64 bit integral data. */
        using FeatStd::UInt64;

        /** Floating point data type.
            Float stores floating point data with 32 bits. */
        using FeatStd::Float;

        /** Double precision data type.
            Double stores floating point data with 64 bits. */
        using FeatStd::Double;

        /** Handle data type.
            Handle stores address data with 32/64 bits, depending on the platform. */
        using FeatStd::Handle;

        /** Type for C/C++ bit field declarations */
        using FeatStd::BitField;
    }
    /// @}
}}

namespace Courier {
    using namespace Courier::Platform::Types;
}

#endif
