//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Platform_SerialPort_h)
#define Courier_Platform_SerialPort_h

#include <Courier/Platform/Base.h>

namespace Courier { namespace Platform {
    /// @addtogroup COURIER_PLATFORM
    /// @{
    namespace StdFileDescriptor {
        /** Ticks object type to create. */
        enum Enum {
            /// Standard input
            StdIn = 0,
            /// Standard output
            StdOut,
            /// Standard error
            StdErr,
            /// Maximum number of standard file descriptors
            Max,
            /// Invalid standard file descriptor marker
            Invalid
        };
    }
/// @}
}}

#include COURIER_PLATFORM_INCLUDE(SerialPort)

namespace Courier { namespace Platform {
    /// @addtogroup COURIER_PLATFORM
    /// @{
    /** SerialPort is a abstraction for serial port access. */
    class SerialPort : private Impl::SerialPort {
        typedef Impl::SerialPort Base;
    public:
        ///
        bool Open(const Char * serialPortPath);

        ///
        bool Close();

        ///
        bool Pipe(StdFileDescriptor::Enum fileDesc, bool activate);

        ///
        Int32 GetDescriptor() const;
    };

    /*  --------------------------------------------------------------------
        Open
        -------------------------------------------------------------------- */
    inline bool SerialPort::Open(const Char * serialPortPath)
    {
        return Base::Open(serialPortPath);
    }

    /*  --------------------------------------------------------------------
        Close
        -------------------------------------------------------------------- */
    inline bool SerialPort::Close()
    {
        return Base::Close();
    }

    /*  --------------------------------------------------------------------
        Map
        -------------------------------------------------------------------- */
    inline bool SerialPort::Pipe(StdFileDescriptor::Enum fileDesc, bool activate)
    {
        return Base::Pipe(fileDesc, activate);
    }

    /*  --------------------------------------------------------------------
        GetDescriptor
        -------------------------------------------------------------------- */
    inline Int32 SerialPort::GetDescriptor() const
    {
        return Base::GetDescriptor();
    }
    /// @}
}}

#endif
