//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Platform_Memory_h)
#define Courier_Platform_Memory_h

#include <Courier/Base.h>

#include <FeatStd/MemoryManagement/Heap.h>

namespace Courier { namespace Platform {
    /** COURIER_NEW allocates an arbitrary object. For Deleting objects on
        that heap, use COURIER_DELETE. COURIER_NEW can be used for object and for POD types. */
    #define COURIER_NEW(type) FEATSTD_NEW(type)

    /** Allocate an object of the given type and pass variadic arguments to the type constructor
        @param type object type to allocate */
    #define COURIER_NEW_ARG(type, ...) FEATSTD_NEW(type, __VA_ARGS__)

    /** COURIER_DELETE deallocates objects created with COURIER_NEW and calls the appropriate destructor if objectPtr
        points to an object type. For POD, no destructor will be called. */
    #define COURIER_DELETE(ptr) FEATSTD_DELETE(ptr)

    /** COURIER_SAFE_DELETE acts like COURIER_DELETE, and additionally sets the given object pointer to 0. */
    #define COURIER_SAFE_DELETE(ptr) FEATSTD_SAFE_DELETE(ptr)

    /** COURIER_NEW_ARRAY creates an array of an arbitrary object or POD type. Count specifies the number of instances to be
        created. Arrays created using this operation need to be deleted with COURIER_DELETE_ARRAY. */
    #define COURIER_NEW_ARRAY(type, count) FEATSTD_NEW_ARRAY(type, count)

    /** COURIER_DELETE_ARRAY deallocates objects allocated with COURIER_NEW_ARRAY. For each element instance the destructor
        is called. */
    #define COURIER_DELETE_ARRAY(ptr) FEATSTD_DELETE_ARRAY(ptr)

    /** COURIER_SAFE_DELETE_ARRAY acts like COURIER_DELETE_ARRAY, and additionally sets the given array pointer to 0. */
    #define COURIER_SAFE_DELETE_ARRAY(ptr) FEATSTD_SAFE_DELETE_ARRAY(ptr)
}}
#endif
