//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Platform_Impl_Os_Posix_PosixSerialPort_h)
#define Courier_Platform_Impl_Os_Posix_PosixSerialPort_h

#include <Courier/Platform/Base.h>
#include <termios.h>

namespace Courier { namespace Platform { namespace Os { namespace Posix {
    /// @addtogroup COURIER_PLATFORM_POSIX
    /// @{
    /** Posix implementation for Platform::SerialPort. */
    class PosixSerialPort {
    public:
        ///
        PosixSerialPort();

        ///
        bool Open(const Char * serialPortPath);

        ///
        bool Close();

        ///
        bool Pipe(StdFileDescriptor::Enum fileDesc, bool activate);

        ///
        Int32 GetDescriptor() const;

    private:
        ///
        int mStdFileDescSave[StdFileDescriptor::Max];

        ///
        int mSerialPortFileDesc;

        ///
        struct termios mSerialSettings;
    };
    /// @}
}}}}

namespace Courier { namespace Platform { namespace Impl {
    typedef Courier::Platform::Os::Posix::PosixSerialPort SerialPort;
}}}

#endif
