//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Platform_Impl_Messaging_DynamicMessageFactory_h)
#define Courier_Platform_Impl_Messaging_DynamicMessageFactory_h

#include <Courier/Platform/Base.h>

#include <Courier/Platform/Memory.h>
// using FeatStd::MemoryManagement::PlatformHeap; // TODO Use this instead of qualification whwn Candera-free

namespace Courier { namespace Platform { namespace Messaging {
/// @addtogroup COURIER_PLATFORM_MESSAGING
/// @{
/**
 * Implements a dynamic memory allocation mechanism.
 * Serves as MessageFactory base class.<br>
 * Implementation works similar to the default new/delete implementation.
 * @remark Implementation uses FeatStd::PlatformHeap.
 * @see MessageFactory
 */
class DynamicMessageFactory
{
public:
    template<typename Type>
    static void* Allocate() {
       return FeatStd::MemoryManagement::PlatformHeap::Alloc(sizeof(Type));
    }

    static void Free(void* memory);

private:
    FEATSTD_MAKE_CLASS_STATIC(DynamicMessageFactory);
};
/// @}
}}}

/**
 * Configures size and memory in StaticMessageFactory for Type.
 * Defined here for convenience reasons (switch between factory types)
 */
#define COURIER_MESSAGE_CONFIGURATION(Type, size)

namespace Courier { namespace Platform { namespace Impl {
    typedef Courier::Platform::Messaging::DynamicMessageFactory MessageFactory;
}}}
#endif
