//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(Courier_MessagingTypes_h)
#define Courier_MessagingTypes_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <FeatStd/Util/StringBuffer.h>

namespace Courier {
namespace MessageTag {
// =========================================================================
/// @addtogroup COURIER_MESSAGING
/// @{
/** The message tag is an additional information to group messages with a special marker.
@note: One message can only be marked with one tag, means every message has only one group membership. */
enum Enum {
/** No marker used. */
    None,
/** Mark message with focus. */
    Focus,
/** Message is used for data binding */
    DataBinding,
/** External message. */
    External,
/** View related message. */
    View,
/** widget related message. */
    Widget
};
/// @}
} // namespace MessageTag
namespace Priority {
// =========================================================================
/// @addtogroup COURIER_MESSAGING
/// @{
/** Message priority. */
enum Enum {
/** Normal message priority. */
    Normal,
/** High message priority. */
    High
};
/// @}
} // namespace Priority
namespace ComponentMessageReceiverTiming {
// =========================================================================
/// @addtogroup COURIER_MESSAGING
/// @{
/** ComponentMessageReceiverTiming enumeration values are representing the operation mode of the ComponentMessageReceiver. */
enum Enum {
/** The timing mechanism is unused (default operation mode of the ComponentMessageReceiver). */
    Unused,
/** A constant timeout value is used, after which the components Execute methods are called. */
    Constant,
/** A corrected timeout value is used, which means previous processing time is considered. Missed calls will be performed immediately. */
    Cycle,
/** A corrected timeout value is used, which means previous processing time is considered. The current time is used ab base for the next cycle. */
    ResyncCycle,
/** A corrected timeout value is used, which means previous processing time is considered. The current time is used as base for the next cycle. 
Additionally it waits for the next message to be processed, so this is the minimum resync cycle time. */
    MinResyncCycle
};
/// @}
} // namespace ComponentMessageReceiverTiming
} // namespace Courier
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
    template<> ::FeatStd::UInt32 StringBufferAppender< ::Courier::MessageTag::Enum >::Append(::FeatStd::StringBuffer& stringBuffer, ::Courier::MessageTag::Enum const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::Courier::Priority::Enum >::Append(::FeatStd::StringBuffer& stringBuffer, ::Courier::Priority::Enum const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::Courier::ComponentMessageReceiverTiming::Enum >::Append(::FeatStd::StringBuffer& stringBuffer, ::Courier::ComponentMessageReceiverTiming::Enum const & object);
} // namespace FeatStd
#endif
#endif // Courier_MessagingTypes_h
