//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(Courier_MessagingMsgs_h)
#define Courier_MessagingMsgs_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
#include <Courier/Serialization/BaseSerializer.h>
#endif
#include <Courier/Messaging/Message.h>
#include <Courier/Platform/MessageFactory.h>
#include <Courier/Messaging/MessagingTypes.h>

namespace Courier {
// ------------------------------------------------------------------------
/// @addtogroup COURIER_MESSAGING
/// @{
                /** Sets the timeout value and operation mode of the component message receiver which the given ComponentId is attachted to.
                * Please refer to Courier::ComponentMessageReceiver::SetCycleTime. 
                */
class SetMessageReceiverCycleTimeMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SetMessageReceiverCycleTimeMsg, ::Courier::Message, 0x7C6CE976);

        SetMessageReceiverCycleTimeMsg();
        SetMessageReceiverCycleTimeMsg(Courier::ComponentId const & aComponentId, Courier::ComponentMessageReceiverTiming::Enum const & aTimingType, FeatStd::UInt32 const & aCycleTime);
        virtual ~SetMessageReceiverCycleTimeMsg();

        Courier::ComponentId const & GetComponentId() const { return mComponentId; }
        void SetComponentId(Courier::ComponentId const & value) { mComponentId = value; }
        Courier::ComponentMessageReceiverTiming::Enum const & GetTimingType() const { return mTimingType; }
        void SetTimingType(Courier::ComponentMessageReceiverTiming::Enum const & value) { mTimingType = value; }
        FeatStd::UInt32 const & GetCycleTime() const { return mCycleTime; }
        void SetCycleTime(FeatStd::UInt32 const & value) { mCycleTime = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSetMessageReceiverCycleTimeMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSetMessageReceiverCycleTimeMsgModifiableMetadata;

        Courier::ComponentId mComponentId;
        Courier::ComponentMessageReceiverTiming::Enum mTimingType;
        FeatStd::UInt32 mCycleTime;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_MESSAGING
/// @{
                /** Sets the minimum cycle time of a component which shall be used.
                * Please refer to Courier::Component::SetMinExecutionCycleTime.
                */
class SetComponentMinExecutionCycleTimeMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SetComponentMinExecutionCycleTimeMsg, ::Courier::Message, 0x8126B682);

        SetComponentMinExecutionCycleTimeMsg();
        SetComponentMinExecutionCycleTimeMsg(Courier::ComponentId const & aComponentId, FeatStd::UInt32 const & aCycleTime, bool const & aAllowMessageInterruption);
        virtual ~SetComponentMinExecutionCycleTimeMsg();

        Courier::ComponentId const & GetComponentId() const { return mComponentId; }
        void SetComponentId(Courier::ComponentId const & value) { mComponentId = value; }
        FeatStd::UInt32 const & GetCycleTime() const { return mCycleTime; }
        void SetCycleTime(FeatStd::UInt32 const & value) { mCycleTime = value; }
        bool const & GetAllowMessageInterruption() const { return mAllowMessageInterruption; }
        void SetAllowMessageInterruption(bool const & value) { mAllowMessageInterruption = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSetComponentMinExecutionCycleTimeMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSetComponentMinExecutionCycleTimeMsgModifiableMetadata;

        Courier::ComponentId mComponentId;
        FeatStd::UInt32 mCycleTime;
        bool mAllowMessageInterruption;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_MESSAGING
/// @{
class TriggerComponentExecuteMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TriggerComponentExecuteMsg, ::Courier::Message, 0xA7CDCEBF);

        TriggerComponentExecuteMsg();
        TriggerComponentExecuteMsg(Courier::ComponentId const & aComponentId);
        virtual ~TriggerComponentExecuteMsg();

        Courier::ComponentId const & GetComponentId() const { return mComponentId; }
        void SetComponentId(Courier::ComponentId const & value) { mComponentId = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTriggerComponentExecuteMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTriggerComponentExecuteMsgModifiableMetadata;

        Courier::ComponentId mComponentId;
};

/// @}
} // namespace Courier
#endif // Courier_MessagingMsgs_h
