//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Messaging_MessageSubscriberListModifier_h)
#define Courier_Messaging_MessageSubscriberListModifier_h

#include <Courier/Base.h>
#include <Courier/Foundation/Component.h>

namespace Courier {  namespace Internal {
    /// @addtogroup COURIER_MESSAGING
    /// @{
    /** Message subscriber list wrapper, which allows to modify the content of the given list. */
    class MessageSubscriberListModifier {
    public:
        ///
        MessageSubscriberListModifier(ComponentId * list, UInt8 listCapacity);

        ///
        bool Add(ComponentId componentId, ComponentId before = ComponentType::Invalid);

        ///
        bool Remove(ComponentId componentId);

        ///
        UInt8 Capacity() const { return mListCapacity; }

        ///
        bool Exists(ComponentId componentId) const;

        ///
        UInt8 Count() const;

    private:
        ComponentId * mList;
        UInt8 mListCapacity;
    };
    /// @}
}}

#endif
