//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Messaging_MessageSubscriberList_h)
#define Courier_Messaging_MessageSubscriberList_h

#include <Courier/Base.h>
#include <Courier/Foundation/Component.h>

// Forward declarations
namespace Courier { namespace UnitTest {
    class MessageTest;
}}

namespace Courier {
    /// @addtogroup COURIER_MESSAGING
    /// @{
    /** Message subscriber list wrapper allows to iterate over the content of the given external managed array,
        using an external iteration index. */
    class MessageSubscriberList {
    public:
        ///
        MessageSubscriberList(
            const ComponentId * list,
            UInt8 listCapacity,
            UInt8 & currentIndex)
            : mList(list), mCurrentIndex(currentIndex), mListCapacity(listCapacity) {
        }

        /** Informs if the list is empty.
            @return <em>true</em> If list is empty,
                    <em>false</em> otherwise. */
        bool IsEmpty() const;

        /** Checks if a given component ID exists in the list.
            @return <em>true</em> If component ID exists,
                    <em>false</em> otherwise. */
        bool Exists(ComponentId componentId) const;

        /** Resets the internal iterator of the list and returns the first element of the list.
            @return <em>The first component ID</em> in the list if list is not empty,
                    <em>ComponentType::Invalid</em> otherwise. */
        ComponentId Begin();

        /** Returns the current element of the list.
            @return <em>The current component ID</em> in the list if list is not empty and iterator has not reached the end of the list,
                    <em>ComponentType::Invalid</em> otherwise. */
        ComponentId Current() const;

        /** Increments the internal iterator of the list and returns the next (means the new current) element of the list.
            @return <em>The next component ID</em> in the list if list is not empty and iterator has not reached the end of the list,
                    <em>ComponentType::Invalid</em> otherwise. */
        ComponentId Next();

        /** Checks if the iterator has reached the end of the list.
            @return <em>true</em> If iteration has ended,
                    <em>false</em> otherwise. */
        bool End() const;

        /** Returns the pointer to the ComponentId list.
            @return <em>ComponentId*</em> the pointer to the list. */
        const ComponentId * GetComponentList() const { return mList; }

    private:
        /** Test private methods. */
        friend class UnitTest::MessageTest;

        /// Pointer to the external managed array.
        const ComponentId * mList;
        /// Reference to the external hold iteration index.
        UInt8 & mCurrentIndex;
        /// Number of elements in the list.
        UInt8 mListCapacity;

        /// Forbid assignment (but default copy constructor is used!)
        MessageSubscriberList & operator=(const MessageSubscriberList &);
    };
    /// @}
}

#endif
