//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "MessageSubscriberList.h"

#if defined(COURIER_IPC_ENABLED)
    #include <Courier/Ipc/IpcComponent.h>
#endif

namespace Courier {
// ------------------------------------------------------------------------
bool MessageSubscriberList::IsEmpty() const
{
    return ((0 == mList) || (0 == mListCapacity) || (ComponentId(ComponentType::Invalid) == *mList));
}

// ------------------------------------------------------------------------
bool MessageSubscriberList::Exists(ComponentId componentId) const
{
    FEATSTD_DEBUG_ASSERT(ComponentId(ComponentType::Invalid) != componentId);
    bool lExists = false;
    if(mList!=0) {

#if defined(COURIER_IPC_ENABLED)
        for (UInt8 i = 0; ((!lExists) && (i < mListCapacity)); i++) {
            lExists = (componentId == *(mList + i));
            if(! lExists) {
                IpcComponentId ipcListComponentId(*(mList + i));
                IpcComponentId ipcComponentId(componentId, IpcComponent::GetLocalPid());
                lExists = (ipcListComponentId == ipcComponentId);
            }
        }
#else
        for (UInt8 i = 0; ((!lExists) && (i < mListCapacity)); i++) {
            lExists = (componentId == *(mList + i));
        }
#endif
    }
    return lExists;
}

// ------------------------------------------------------------------------
ComponentId MessageSubscriberList::Begin()
{
    mCurrentIndex = 0;
    return Current();
}

// ------------------------------------------------------------------------
ComponentId MessageSubscriberList::Current() const
{
    if ((mList==0) || IsEmpty() || End()) {
        return ComponentId(ComponentType::Invalid);
    }
    return *(mList + mCurrentIndex);
}

// ------------------------------------------------------------------------
ComponentId MessageSubscriberList::Next()
{
    if ((!IsEmpty()) && (!End())) {
        ++mCurrentIndex;
    }
    return Current();
}

// ------------------------------------------------------------------------
bool MessageSubscriberList::End() const
{
    return (IsEmpty() || (mCurrentIndex == mListCapacity) || ((mList!=0) && (ComponentId(ComponentType::Invalid) == *(mList + mCurrentIndex))));
}
}
