//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Macros_h)
#define Courier_Macros_h

#include <FeatStd/Util/ConvenienceMacros.h>

/// @addtogroup COURIER_UTIL
/// @{
/** Value for macros that expand to nothing in specific (release) build modes generate.
    some tool chains generate "extra ';' ignored" warnings if the macro is terminated with a ';'.
    Use this macro as value for the expand to nothing macro variant. */
#if defined(__GNUC__) // for GCC supress the extra warning: typedef �ZZZDummyTypeFromEmptyMacroExpansion34� locally defined but not used [-Wunused-local-typedefs]
#define COURIER_EXPAND_TO_EMPTY_MACRO()
#else
#define COURIER_EXPAND_TO_EMPTY_MACRO() \
    FEATSTD_LINT_SYMBOL(751, FEATSTD_CONCAT2(ZZZDummyTypeFromEmptyMacroExpansion, __LINE__), "dummy definition for empty macro expansion") \
    FEATSTD_LINT_SYMBOL(578, FEATSTD_CONCAT2(ZZZDummyTypeFromEmptyMacroExpansion, __LINE__), "dummy definition for empty macro expansion, can be hidden without risk") \
    typedef void FEATSTD_CONCAT2(ZZZDummyTypeFromEmptyMacroExpansion, __LINE__)
#endif
/******************************************************************************
 *  Macros to allow unit test class as friend of Courier classes
 *
 *  usage in .h file:
 *  @code
 *  COURIER_UNIT_TEST_CLASS_DECLARATION(TestClass);
 *  COURIER_UNIT_TEST_TESTCASE_DECLARATION(TestCaseName, TestName);
 *
 *  namespace FeatStd {
 *      class A
 *      {
 *          ...
 *          private:
 *              COURIER_UNIT_TEST_CLASS_FRIEND(TestClass);
 *              COURIER_UNIT_TEST_TESTCASE_FRIEND(TestCaseName, TestName);
 *              ...
 *      };
 *      ....
 *  }
 *  @endcode
 ******************************************************************************/
#define COURIER_UNIT_TEST_CLASS_DECLARATION(className) \
    namespace Courier { namespace UnitTest { \
        class className; \
    }}

#define COURIER_UNIT_TEST_TESTCASE_DECLARATION(testCaseName, testName) \
    namespace Courier { namespace UnitTest { \
        class _FEATSTD_UNIT_TEST_CLASS_NAME(testCaseName, testName); \
    }}

#define COURIER_UNIT_TEST_CLASS_FRIEND(className) \
    friend class Courier::UnitTest::className

#define COURIER_UNIT_TEST_TESTCASE_FRIEND(testCaseName, testName) \
    friend class Courier::UnitTest::_FEATSTD_UNIT_TEST_CLASS_NAME(testCaseName, testName)

// Obsolete! Just for Backward compatibility
#define COURIER_UNUSED(a)              FEATSTD_UNUSED(a)
#define COURIER_UNUSED2(a, b)          FEATSTD_UNUSED2(a, b)
#define COURIER_UNUSED3(a, b, c)       FEATSTD_UNUSED3(a, b, c)
#define COURIER_UNUSED4(a, b, c, d)    FEATSTD_UNUSED4(a, b, c, d)
#define COURIER_UNUSED5(a, b, c, d, e) FEATSTD_UNUSED5(a, b, c, d, e)

#define COURIER_DEBUG_UNUSED(a)   FEATSTD_DEBUG_UNUSED(a)
#define COURIER_RELEASE_UNUSED(a) FEATSTD_RELEASE_UNUSED(a)

#define COURIER_LINT_CTORDTOR_EFFECT(classname)               FEATSTD_LINT_CTORDTOR_EFFECT(classname)
#define COURIER_LINT_SINGLETON(classname)                     FEATSTD_LINT_SINGLETON(classname)
#define COURIER_LINT_INITIALIZER_FUNCTION(symbol)             FEATSTD_LINT_INITIALIZER_FUNCTION(symbol)
#define COURIER_LINT_CLEANUP_FUNCTION(symbol)                 FEATSTD_LINT_CLEANUP_FUNCTION(symbol)
#define COURIER_LINT_NONCONST_METHOD(symbol, reason)          FEATSTD_LINT_NONCONST_METHOD(symbol, reason)
#define COURIER_LINT_IGNORE_RETURN_VALUE(symbol)              FEATSTD_LINT_IGNORE_RETURN_VALUE(symbol)
#define COURIER_LINT_MACRO_WHILEFALSE(macroname)              FEATSTD_LINT_MACRO_WHILEFALSE(macroname)
#define COURIER_LINT_MACRO(message_number, macroname, reason) FEATSTD_LINT_MACRO(message_number, macroname, reason)
#define COURIER_LINT_FILE(message_number, filename, reason)   FEATSTD_LINT_FILE(message_number, filename, reason)
#define COURIER_LINT_SYMBOL(message_number, symbol, reason)   FEATSTD_LINT_SYMBOL(message_number, symbol, reason)
#define COURIER_LINT_CURRENT_SCOPE(message_number, reason)    FEATSTD_LINT_CURRENT_SCOPE(message_number, reason)
#define COURIER_LINT_NEXT_EXPRESSION(message_number, reason)  FEATSTD_LINT_NEXT_EXPRESSION(message_number, reason)
#define COURIER_LINT_POSSIBLE_USE_OF_NULL_POINTER(reason)     FEATSTD_LINT_POSSIBLE_USE_OF_NULL_POINTER(reason)
#define COURIER_LINT_FALLTHROUGH(reason)                      FEATSTD_LINT_FALLTHROUGH(reason)
/// @}
#endif
