//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Foundation_ExtCommInputHandler_h)
#define Courier_Foundation_ExtCommInputHandler_h

#include <Courier/Base.h>
#include <Courier/Util/LinkedList.h>

// Forward declarations
namespace Courier {
    class Message;
}

namespace Courier {
    /// @addtogroup COURIER_FOUNDATION
    /// @{
    /// Base class for external communication input handler.
    class ExtCommInputHandler
    {
    public:
        /// Input handler linked list node.
        Internal::LinkedListNode<ExtCommInputHandler> ExtCommInputHandlerListNode;

        ///
        virtual ~ExtCommInputHandler() {}

    //! [COURIER_ExtCommInputHandler_Interface]
        ///
        static bool Post(Message * msg);

        ///
        virtual void Listen() = 0;
    //! [COURIER_ExtCommInputHandler_Interface]
    };
    /// @}
}

#endif
