//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Foundation_ControllerComponent_h)
#define Courier_Foundation_ControllerComponent_h

#include <Courier/Foundation/Component.h>

// Forward declarations
namespace Courier {
    class Message;
}

namespace Courier {
    /// @addtogroup COURIER_FOUNDATION
    /// @{
    /** The ControllerComponent is the instance which is controlling the views.
        A derived class may trigger creating, removing and activating of views (executed by the ViewComponent).
        It may be able to consume messages and therefore react accordingly to those messages.
        A class has to be derived to add message processing functionality.
    */
    class ControllerComponent : public Component {
    public:
        /** Constructs a ControllerComponent. */
        ControllerComponent();

        ///
        virtual ~ControllerComponent();
    };
    /// @}
}

#endif
