//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Diagnostics_TraceControl_h)
#define Courier_Diagnostics_TraceControl_h

#include <Courier/Base.h>

#include "TraceIds.h"

#ifdef FEATSTD_LOG_ENABLED
    #include <FeatStd/Diagnostics/LogEvent.h>
#endif
#include <FeatStd/Diagnostics/LocationInfo.h>

namespace Courier {
    class Message;
}

namespace Courier { namespace Diagnostics {
/// @addtogroup COURIER_DIAGNOSTICS
/// @{
class ITraceControlHook;

/**
 * Main class for tracing.
 * Functionality is mainly used from Trace.h.
 */
class TraceControl
{
public:
    static bool IsEnabled();
    static void SetEnabled(bool state);

#ifdef FEATSTD_LOG_ENABLED
    /**
     * Forwards a log event to Trace channel.
     * @remark Will be called in disabled state also!
     */
    static void Mirror_LogEvent(const FeatStd::Diagnostics::LogEvent& logEvent);
#endif

    /**
     * Trace message (see COURIER_TRACE_MESSAGE macro).
     * @remark Mustn't be called in disabled state!
     */
    static void Forced_Message(TraceId::Enum traceId,
                               const Message* message,
                               const FeatStd::Diagnostics::LocationInfo& location);

    /**
     * Sets hook to overwrite default behaviour.
     * @param hookObject New hook object.
     * @returns previous hook object.
     */
    static ITraceControlHook* SetHook(ITraceControlHook* hookObject);

private:
    static ITraceControlHook* mHookObject;

    FEATSTD_MAKE_CLASS_STATIC(TraceControl);
};

/**
 * Interface for hook object implementation.
 */
class ITraceControlHook
{
public:
#ifdef FEATSTD_LOG_ENABLED
    virtual void Hook_Mirror_LogEvent(const FeatStd::Diagnostics::LogEvent& logEvent) = 0;
#endif

    virtual void Hook_Forced_Message(TraceId::Enum traceId,
                                     const Message* message,
                                     const FeatStd::Diagnostics::LocationInfo& location) = 0;
};
/// @}
}}

#endif
