//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "TraceControl.h"

#include <Courier/Messaging/Message.h>
#include <FeatStd/Diagnostics/Tracer.h>

#if defined(FEATSTD_LOG_ENABLED)
    FEATSTD_LINT_NEXT_EXPRESSION(537, "ignore lint warning")
    #include <FeatStd/Diagnostics/Log.h>
    #include <Courier/Diagnostics/LogRealm.h>
#endif

namespace Courier { namespace Diagnostics {

#if defined(FEATSTD_LOG_ENABLED)
    using FeatStd::Diagnostics::Logger;
#endif

using FeatStd::Diagnostics::Tracer;

// ------------------------------------------------------------------------

ITraceControlHook* TraceControl::mHookObject = 0;

// ------------------------------------------------------------------------
bool TraceControl::IsEnabled()
{
    return Tracer::IsEnabled();
}

// ------------------------------------------------------------------------
void TraceControl::SetEnabled(bool state)
{
    Tracer::SetEnabled(state);
}

// ------------------------------------------------------------------------
#ifdef FEATSTD_LOG_ENABLED
void TraceControl::Mirror_LogEvent(const FeatStd::Diagnostics::LogEvent& logEvent)
{
    if (mHookObject != 0) {
        mHookObject->Hook_Mirror_LogEvent(logEvent);
        return;
    }

    Tracer::Mirror_LogEvent(logEvent);
}
#endif

// ------------------------------------------------------------------------
void TraceControl::Forced_Message(TraceId::Enum traceId,
                                  const Message* message,
                                  const FeatStd::Diagnostics::LocationInfo& location)
{
    FEATSTD_DEBUG_ASSERT(IsEnabled());

    FEATSTD_DEBUG_ASSERT(message != 0);
    if (message == 0) {
        return; // Robustness
    }

    if (mHookObject != 0) {
        mHookObject->Hook_Forced_Message(traceId, message, location);
        return;
    }

    FEATSTD_DEBUG_ASSERT(message != 0);
#ifdef FEATSTD_LOG_ENABLED
    // Hard coded delivery target
    using namespace FeatStd::Diagnostics;
    const LogLevel::Enum lLevel(LogLevel::Fatal);
    Logger& lLogger(LogControl::GetLogger<LogRealm::Messaging>());
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
    const UInt16 lTraceLength(FEATSTD_LOGGER_MAX_BUFFER_SIZE); // Includes \0!
    FeatStd::FixedSizeStringBuffer<lTraceLength>::StringType messageAsText;
    FeatStd::FixedSizeStringBuffer<lTraceLength> stringBuffer(messageAsText);
    stringBuffer.AppendObject(message);
    lLogger.ForcedLog(lLevel, location,
                      "COURIER_TRACE_MESSAGE %d: %s",
                      traceId, messageAsText.CStr());
#else
    lLogger.ForcedLog(lLevel, location,
                      "COURIER_TRACE_MESSAGE %d: 0x%8X(%s)",
                      traceId, message->GetId(), message->GetName());
#endif
#else
    FEATSTD_UNUSED2(traceId, location);
#endif
}

ITraceControlHook* TraceControl::SetHook(ITraceControlHook* hookObject)
{
    ITraceControlHook*const lOldHookObject(mHookObject);
    mHookObject = hookObject;
    return lOldHookObject;
}
}}
