//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Diagnostics_Log_h)
#define Courier_Diagnostics_Log_h

#include <FeatStd/Diagnostics/Log.h>

namespace Courier { namespace Diagnostics {}}  //Create empty namespace for when logging is disabled

#ifdef FEATSTD_LOG_ENABLED
    #include <Courier/Diagnostics/LogLevel.h>
    #include <Courier/Diagnostics/LogRealm.h>
    #include <Courier/Diagnostics/LogControl.h>

    #include <Courier/Diagnostics/LocationInfo.h>
#endif

/// @addtogroup COURIER_DIAGNOSTICS
/// @{
/**
 * Sets LogRealm to be used by COURIER_LOG_<LogLevel> output macros.
 * Usage: <br>
 *   Insert >COURIER_LOG_SET_REALM(Courier::Diagnostics::LogRealm::xxx);<
 *   either in class declaration or in implementation file.
 */
#define COURIER_LOG_SET_REALM(logRealm) FEATSTD_LOG_SET_REALM(logRealm)

/**
 * Prints a log message using LogLevel Debug.
 * Example: <br>
 *   COURIER_LOG_DEBUG("Top left edge: %d, %d", rect.GetX(), rect.GetY());
 * @param args The actual message to print.
 */
#define COURIER_LOG_DEBUG(args, ...) FEATSTD_LOG_DEBUG(args, ## __VA_ARGS__)
#define COURIER_LOG_INFO(args, ...)  FEATSTD_LOG_INFO(args,  ## __VA_ARGS__)
#define COURIER_LOG_WARN(args, ...)  FEATSTD_LOG_WARN(args,  ## __VA_ARGS__)
#define COURIER_LOG_ERROR(args, ...) FEATSTD_LOG_ERROR(args, ## __VA_ARGS__)
#define COURIER_LOG_FATAL(args, ...) FEATSTD_LOG_FATAL(args, ## __VA_ARGS__)

#define COURIER_LOG_REALM(logRealm, logLevel, args, ...) FEATSTD_LOG_REALM(logRealm, logLevel, args, ## __VA_ARGS__)
/// @}
#endif
