//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ContextCheck.h"
FEATSTD_LINT_FILE(537, ContextCheck.h, Own .h should always be included)

#if defined(COURIER_ENABLE_CONTEXT_AFFINITY_CHECKS)

namespace Courier { namespace Internal {
    // =====================================================================

    // ---------------------------------------------------------------------
    AffinityObject::AffinityObject()
    {
        mIsLinked = false;
        mIsSynced = false;
        mSharedReadOnly = false;
        mData.mThreadId = Platform::Thread::GetCurrentId();
    }

    // ---------------------------------------------------------------------
    AffinityObject::~AffinityObject()
    {
        FEATSTD_DEBUG_ASSERT(mIsSynced ||
                             mIsLinked ||
                             (GetThreadId() == Platform::Thread::GetCurrentId()));
    }

    // ---------------------------------------------------------------------
    AffinityObject& AffinityObject::LinkTo(AffinityObject &affinityObject)
    {
        AffinityObject &thisResolved = Resolve();
        AffinityObject &aoResolved = affinityObject.Resolve();

        FEATSTD_DEBUG_ASSERT(&thisResolved != &aoResolved);

        if (&thisResolved != &aoResolved) {
            thisResolved.mIsLinked = true;
            thisResolved.mData.mLinkedAffinityObject = &aoResolved;
        }
        return aoResolved;
    }

    // ---------------------------------------------------------------------
    void AffinityObject::Unlink()
    {
        FEATSTD_DEBUG_ASSERT(mIsLinked);
        if (mIsLinked) {
            // resolve the linked affinity object
            const AffinityObject &resolved = Resolve();

            // now unlink by taking over the configuration of the resolved object
            *this = resolved;
        }
    }

    // ---------------------------------------------------------------------
    const AffinityObject& AffinityObject::ResolveLinkedObject() const
    {
        const AffinityObject *affintiyObject = this;
        while (affintiyObject->mIsLinked) {
            affintiyObject = affintiyObject->mData.mLinkedAffinityObject;
        }
        return *affintiyObject;
    }

    // ---------------------------------------------------------------------
    AffinityObject& AffinityObject::Resolve()
    {
        AffinityObject *affintiyObject = this;
        while (affintiyObject->mIsLinked) {
            affintiyObject = affintiyObject->mData.mLinkedAffinityObject;
        }
        return *affintiyObject;
    }

    // =====================================================================

    // ---------------------------------------------------------------------
    bool CheckObjectThreadAffinity(const AffinityObject &affinityObject, bool isConst)
    {
        // context affinity must not be checked if the object is externally synced
        bool ok = affinityObject.IsExternallySynced();

        if (!ok) {
            // if the object is shared read only and the member function is const (the object is const)
            // affinity must not be checked
            if (affinityObject.IsSharedReadOnly()) {
                ok = isConst;
            }
            else {
                ok = affinityObject.GetThreadId() == Courier::Platform::Thread::GetCurrentId();
            }
        }

        // if neither externally synced or shared read only, check if the invoking context
        // equals the context affine to the object
        return ok;
    }

    // =====================================================================

    bool ComponentThreadContextPool::mComponentThreadIdSet[ComponentType::CustomerLast + 1];
    UInt32 ComponentThreadContextPool::mComponentThreadId[ComponentType::CustomerLast + 1];

    // ---------------------------------------------------------------------
    void ComponentThreadContextPool::SetThreadId(ComponentId componentId, UInt32 threadId)
    {
        mComponentThreadId[componentId] = threadId;
        mComponentThreadIdSet[componentId] = true;
    }
}}
#else
#if defined(_MSC_VER)
namespace Courier {
    namespace Internal {
        namespace {
            Char ContextCheck_dummy; // avoid LNK4221
        }
    }
}
#endif    
#endif
