//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_DataBinding_PropertyBindingData_h)
#define Courier_DataBinding_PropertyBindingData_h

#include <CanderaWidget/WidgetBase/WidgetMetaInfo.h>
#include <Courier/Visualization/FrameworkWidget.h>
#include <Courier/DataBinding/DataBindingFwd.h>
#include <Courier/DataBinding/BindingBase.h>

namespace Courier { namespace Internal {
/// @addtogroup COURIER_DATABINDING
/// @{
    /** defines a binding between a data item in the model component and a widget property */
    class PropertyBindingData {
        public:
            typedef ::Candera::MetaInfo::WidgetPropertyMetaInfo PropertyMetaInfo;

            PropertyBindingData();
            virtual ~PropertyBindingData();

            /** returns the name of the bound widget property */
            const Char* GetPropertyName() const;

            const PropertyMetaInfo* GetMeta() const {
                return mPropertyMetaInfo;
            }

            void SetMeta(const PropertyMetaInfo* meta) {
                mPropertyMetaInfo = meta;
            }

            const Internal::DataBinding::BindablePropertyCapability* GetCapabilityObject() const;

        private:
            const PropertyMetaInfo *mPropertyMetaInfo;  ///< pointer to the meta info object of the widget property

            friend struct WidgetBindingListAccessor;
            friend class DataBinding::Async::AsyncWidgetPropertyBinding;
    };

//@}
}}   // namespace

#endif // Courier_DataBinding_PropertyBindingData_h
