//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "PropertyBindingData.h"

#include <Courier/DataBinding/BindableProperty.h>
#include <Courier/DataBinding/MetaInfoUtil.h>

namespace Courier { 

using namespace Candera::MetaInfo;
using namespace Internal::DataBinding;

namespace Internal {
    // ------------------------------------------------------------------------
    PropertyBindingData::PropertyBindingData() : mPropertyMetaInfo(0)
    {
    }

    // ------------------------------------------------------------------------
    PropertyBindingData::~PropertyBindingData()
    {
        mPropertyMetaInfo = 0;
    }

    // ------------------------------------------------------------------------
    const Char* PropertyBindingData::GetPropertyName() const
    {
        return (mPropertyMetaInfo != 0) ? mPropertyMetaInfo->GetName() : "";
    }

    // ------------------------------------------------------------------------
    const BindablePropertyCapability* PropertyBindingData::GetCapabilityObject() const
    {
        return (mPropertyMetaInfo != 0) ? BindablePropertyCapability::ConvertFrom(mPropertyMetaInfo->GetCapability()) : 0;
    }

}}   // namespace

