//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#include "ModelBindingSource.h"
#include "ModelBindingSourceMap.h"
#include "DataBindingMsg.h"
#include "MetaInfoUtil.h"

namespace Courier { namespace Internal {
    using namespace Internal::DataBinding;

    // ------------------------------------------------------------------------
    ModelBindingSource::ModelBindingSource(DataItemKey itemKey) :
        mModelBindingSourceDelegationConnectorHead(0),
        mComponentId(ComponentId(ComponentType::Invalid)),
        mItemKey(itemKey)
    {
        FEATSTD_DEBUG_ASSERT(DataItemAccessor::IsRootItem(itemKey));
    }

    // ------------------------------------------------------------------------
    ModelBindingSource::~ModelBindingSource()
    {
    }

    // ------------------------------------------------------------------------
    void ModelBindingSource::ReleaseDataItemMsgReference()
    {
    }
}}   // namespace

namespace Courier{
    using namespace Internal::DataBinding;
    using namespace Internal;

    // ========================================================================

    // ------------------------------------------------------------------------
    bool CreateBinding(DataItemKey itemKey, const Candera::MetaInfo::WidgetPropertyMetaInfo *wpmi,
                       FrameworkWidget *widgetInstance, bool typeConvert,
                       const DataItemValue &defaultValue, const Candera::AbstractNodePointer& node)
    {
        const DataItemHierarchyNode *localNode = DataItemAccessor::Node(itemKey);
        ModelBindingSource *bindingSource = ModelBindingSourceMap::Locate(ComponentId(ComponentType::View), DataItemAccessor::Root(localNode)->mItemKey, node);

        FEATSTD_DEBUG_ASSERT((wpmi != 0) && (widgetInstance != 0));

        return (wpmi != 0) &&
               (bindingSource != 0) &&
               bindingSource->CreateBinding(itemKey, wpmi, widgetInstance, typeConvert, defaultValue);
    }


    // ------------------------------------------------------------------------
    bool CreateBinding(DataItemKey itemKey, const Char *widgetType, const Char *propertyName,
        FrameworkWidget *widgetInstance, bool typeConvert, const DataItemValue &defaultValue, const Candera::AbstractNodePointer& node)
    {
        const Candera::MetaInfo::WidgetPropertyMetaInfo *wpmi = GetWidgetPropertyMetaInfo(widgetType, propertyName);
        return (wpmi != 0) && CreateBinding(itemKey, wpmi, widgetInstance, typeConvert, defaultValue, node);
    }

    typedef ObjectListIterator<ModelBindingSourceDelegationConnector, DefaultAccessor<ModelBindingSourceDelegationConnector> > ModelBindingSourceDelegationConnectorIterator;
    typedef ObjectListFunc<ModelBindingSourceDelegationConnector, DefaultAccessor<ModelBindingSourceDelegationConnector> >ModelBindingSourceDelegationConnectorIteratorList;

    // ------------------------------------------------------------------------
    void ModelBindingSource::ProcessDataItemMsg(const AbstractDataItemMsg *msg)
    {
        OnDataItemMsg(msg);
        for (ModelBindingSourceDelegationConnectorIterator it(mModelBindingSourceDelegationConnectorHead); it != 0; ++it) {
            (*it)->DelegateDataItemMsg(msg);
        }
    }

    // ------------------------------------------------------------------------
    void ModelBindingSource::ProcessListEventMsg(const ListEventMsg *msg)
    {
        OnListEventMsg(msg);
        for (ModelBindingSourceDelegationConnectorIterator it(mModelBindingSourceDelegationConnectorHead); it != 0; ++it) {
            (*it)->DelegateListEventMsg(msg);
        }
    }

    // ------------------------------------------------------------------------
    void ModelBindingSource::ProcessReleaseDataItemMsgReference()
    {
        ReleaseDataItemMsgReference();
        for (ModelBindingSourceDelegationConnectorIterator it(mModelBindingSourceDelegationConnectorHead); it != 0; ++it) {
            (*it)->DelegateReleaseDataItemMsgReference();
        }
    }

    // ------------------------------------------------------------------------
    bool ModelBindingSource::EnlistModelBindingSourceDelegationConnector(ModelBindingSourceDelegationConnector *modelBindingSourceDelegationConnector)
    {
        return ModelBindingSourceDelegationConnectorIteratorList::Add(mModelBindingSourceDelegationConnectorHead, modelBindingSourceDelegationConnector);
    }

    // ------------------------------------------------------------------------
    bool ModelBindingSource::UnlistModelBindingSourceDelegationConnector(ModelBindingSourceDelegationConnector *modelBindingSourceDelegationConnector)
    {
        return ModelBindingSourceDelegationConnectorIteratorList::Remove(mModelBindingSourceDelegationConnectorHead, modelBindingSourceDelegationConnector);
    }
}

