//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_DataBinding_MetaInfoUtil_h)
#define Courier_DataBinding_MetaInfoUtil_h

#include <Candera/System/MetaInfo/MetaInfo.h>
#include <CanderaWidget/WidgetBase/WidgetBase.h>

#include <Courier/Base.h>

namespace Courier { namespace Internal {
/// @addtogroup COURIER_DATABINDING
/// @{
    /** retrieves WidgetMetaInfo object owning the given WidgetPropertyMetaInfo
        NOTE: Only the bindable property is unique per WidgetMetaInfo.
        For all other properties it is undefined (depending on the order in the widget set) which WidgetMetaInfo is returned.
        Because there is no unique mapping of the shared WidgetPropertyMetaInfo to a specific WidgetMetaInfo.
    @param wpmi the WidgetPropertyMetaInfo
        @return pointer to WidgetMetaInfo object */
    extern const Candera::MetaInfo::WidgetMetaInfo* GetWidgetMetaInfo(const Candera::MetaInfo::WidgetPropertyMetaInfo *wpmi);

    /** retrieves WidgetMetaInfo object of the specified widget
        @param widgetName the type name of the widget
        @return pointer to the WidgetMetaInfo or 0 (null) if the widget type is unknown
                (ie. not set in WidgetSet) */
    extern const ::Candera::MetaInfo::WidgetMetaInfo* GetWidgetMetaInfo(const Char *widgetName);

    /** retrieves WidgetPropertyMetaInfo object of the specified widget property
        @param widgetName the type name of the widget
        @param propertyName the name of the property
        @return pointer to the WidgetPropertyMetaInfo or 0 (null) if the widget type is unknown
                or the widget type has no widget with the given name */
    extern const ::Candera::MetaInfo::WidgetPropertyMetaInfo* GetWidgetPropertyMetaInfo(const Char *widgetName, const Char *propertyName);

//@}
}}
#endif // Courier_DataBinding_MetaInfoUtil_h
