//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_DataBinding_DataItemAccessor_h)
#define Courier_DataBinding_DataItemAccessor_h

#include <Courier/DataBinding/DataItemValue.h>
#include <Courier/DataBinding/Infrastructure.h>

namespace Courier {
    namespace Internal {
        /// @addtogroup COURIER_DATABINDING
        /// @{
        namespace DataBinding {
            class DataItemAccessor {
            public:
                template<typename T> static inline DataItemValue GetImmutableValue(DataItemKey itemKey, const T &object) {
                    return GetImmutableValue(Node(itemKey), object);
                }

                static DataItemValue GetImmutableValue(DataItemKey itemKey, const DataItemValue &value) {
                    return Courier::Internal::DataBinding::DataItemAccessor::GetImmutableValue(Node(itemKey), value.ImmutablePointer(), value.TypeId());
                }

                static DataItemValue GetMutableValue(DataItemKey itemKey, const DataItemValue &value) {
                    return Courier::Internal::DataBinding::DataItemAccessor::GetMutableValue(Node(itemKey), value.MutablePointer(), value.TypeId());
                }

                template<typename T> static inline DataItemValue GetMutableValue(DataItemKey itemKey, T &object) {
                    return GetMutableValue(Node(itemKey), object);
                }

                template<typename T> static inline bool SetValue(DataItemKey itemKey, T &object, const DataItemValue &value) {
                    return SetValue(Node(itemKey), object, value);
                }

                static inline HierarchyNodeIndex GetLocalNodeIndex(DataItemKey itemKey) {
                    return Node(itemKey)->mLocalIndex;
                }

                static DataItemKey Parent(DataItemKey itemKey) {
                    const DataItemHierarchyNode *hn = Node(itemKey);
                    return hn->IsRootNode() ? cInvalidDataItemKey : Parent(hn)->mItemKey;
                }

                static DataItemKey Root(DataItemKey itemKey) {
                    const DataItemHierarchyNode *hn = Node(itemKey);
                    return hn->IsRootNode() ? itemKey : Root(hn)->mItemKey;
                }

                static inline bool IsValid(DataItemKey itemKey) {
                    return itemKey != cInvalidDataItemKey;
                }

                static inline BindingSourceIndex GetBindingSourceIndex(DataItemKey itemKey) {
                    return Node(itemKey)->mBindingSourceIndex;
                }

                static inline const DataItemDescriptor& Descriptor(DataItemKey itemKey) {
                    return Descriptor(Node(itemKey));
                }

                static inline bool IsRootItem(DataItemKey itemKey) {
                    return Node(itemKey)->IsRootNode();
                }

                static inline bool IsReadOnlyItem(DataItemKey itemKey) {
                    return Node(itemKey)->IsReadOnly();
                }

                static inline DataItemKey ItemKey(BindingSourceIndex bsIndex, HierarchyNodeIndex hnIndex) {
                    return Node(bsIndex, hnIndex)->mItemKey;
                }

                template<typename T> static inline DataItemValue GetImmutableValue(const DataItemHierarchyNode *hn, const T &object) {
                    return GetImmutableValue(hn, &object, DataItemType<T>::Ident());
                }

                template<typename T> static inline DataItemValue GetMutableValue(const DataItemHierarchyNode *hn, T &object) {
                    return GetMutableValue(hn, &object, DataItemType<T>::Ident());
                }

                template<typename T> static inline bool SetValue(const DataItemHierarchyNode *hn, T &object, const DataItemValue &value) {
                    return SetValue(hn, &object, DataItemType<T>::Ident(), value);
                }

                static inline const DataItemHierarchyNode* Parent(const DataItemHierarchyNode *hn) {
                    return &gInfrastructure->Node(hn->mBindingSourceIndex, hn->mParentIndex);
                }

                static inline const DataItemHierarchyNode* Root(const DataItemHierarchyNode *hn) {
                    return &gInfrastructure->Node(hn->mBindingSourceIndex, 0);
                }

                static inline const DataItemDescriptor& Descriptor(const DataItemHierarchyNode *hn) {
                    return gInfrastructure->Descriptor(hn->mDescriptorIndex);
                }

                static inline const DataItemHierarchyNode* Node(DataItemKey itemKey) {
                    return &gInfrastructure->Node(itemKey);
                }

                static inline const DataItemHierarchyNode* Node(BindingSourceIndex bsIndex, HierarchyNodeIndex hnIndex) {
                    return &gInfrastructure->Node(bsIndex, hnIndex);
                }

                static inline const DataItemHierarchyNode* InvalidNode() {
                    return gInfrastructure->mBindingSourceNodes[0].mNodes;
                }

                static inline DataItemKey ItemKey(const DataItemHierarchyNode *hn) {
                    return hn->mItemKey;
                }

                static const DataItemHierarchyNode* Locate(UInt32 hash);

            private:
                static DataItemValue GetImmutableValue(const DataItemHierarchyNode *hnItem, const void *object, DataItemTypeId typeId);
                static DataItemValue GetMutableValue(const DataItemHierarchyNode *hn, void *object, DataItemTypeId typeId);
                static bool SetValue(const DataItemHierarchyNode *hn, void *object, DataItemTypeId typeId, const DataItemValue &value);
                static void* TraverseUp(const DataItemHierarchyNode *hn, DataItemTypeId typeId, void *object);

                FEATSTD_MAKE_CLASS_STATIC(DataItemAccessor);
            };
        }
    }

    //@}
}

#endif // Courier_DataBinding_DataItemAccessor_h
