//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <Courier/Util/Limits.h>
#include "BindingSourceRevisionStore.h"


namespace Courier { 

    using namespace Internal;
    using Internal::DataBinding::DataItemAccessor;

    BindingSourceRevisionStore *BindingSourceRevisionStore::mInstance = 0;

    // ------------------------------------------------------------------------
    UInt16 BindingSourceRevisionStore::GetRevision(DataItemKey bindingSourceItemKey) 
    {
        UInt16 revision = 0;
        if (mInstance != 0) {
            BindingSourceIndex index = DataItemAccessor::GetBindingSourceIndex(bindingSourceItemKey);
            revision = mInstance->GetRevisionImpl(index);
        }
        return revision;
    }

    // ------------------------------------------------------------------------
    void BindingSourceRevisionStore::SetRevision(DataItemKey bindingSourceItemKey, UInt16 dataRevision) 
    {
        if (mInstance != 0) {
            BindingSourceIndex index = DataItemAccessor::GetBindingSourceIndex(bindingSourceItemKey);
            mInstance->SetRevisionImpl(index, dataRevision);
        }
    }

    // ------------------------------------------------------------------------
    UInt16 BindingSourceRevisionStore::IncRevision(DataItemKey bindingSourceItemKey) 
    {
        UInt16 revision = 0;
        if (mInstance != 0) {
            BindingSourceIndex index = DataItemAccessor::GetBindingSourceIndex(bindingSourceItemKey);
            revision = mInstance->GetRevisionImpl(index);
            ++revision;
            mInstance->SetRevisionImpl(index, revision);
        }
        return revision;
    }

    // ------------------------------------------------------------------------
    Int32 BindingSourceRevisionStore::Compare(UInt16 revisionLeft, UInt16 revisionRight) 
    {
        Int32 revision = Int32(revisionLeft) - Int32(revisionRight);
        static const Int32 delta = Limits<UInt16>::cMaxValue / 2;
        // if difference of revisions is larger then 32768 the smaller revision had an 
        // overflow and the comparison result must be reversed
        return ((revision <= -delta) || (revision >= delta)) ? -revision : revision;
    }

}   // namespace 
