//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "BindingBase.h"

#include <Courier/DataBinding/ModelBindingTargetHost.h>


namespace Courier { namespace Internal {

    BindingBase::BindingBase() :
        mTarget(0),
        mBindingTargetNext(0)
    { }
    
    BindingBase::~BindingBase()
    {
        if (mTarget != 0) {
            (void) mTarget->Unlist(this);
        }

        mTarget = 0;
        mBindingTargetNext = 0;
    }

    bool BindingBase::InternalInit(ModelBindingTargetHost *target)
    {
        bool ok = (target != 0) && (mTarget == 0);
        if (ok) {
            mTarget = target;
            FEATSTD_LINT_POSSIBLE_USE_OF_NULL_POINTER("target pointer checked at function entry")
            ok = mTarget->Enlist(this);
        }
        return ok;
    }

}}
