//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_DataBinding_Binding_h)
#define Courier_DataBinding_Binding_h

#include <FeatStd/Platform/Types.h>

namespace Courier { 
    
    /// @addtogroup COURIER_DATABINDING
    /// @{

    namespace Internal {

    /**
     * Interface for bindings between a binding source and a 
     * binding target (e.g. a widget).
     */
    class Binding {
    public:

        /**
         * Deletes this binding and releases all resources.
         */
        virtual void Destroy() = 0;

        /**
         * @return  The name of the bound target.
         */
        virtual const FeatStd::Char* GetTargetName() const = 0;

        /**
         * Indicate, that the target of this binding has been modified.
         */
        virtual void SetTargetModifiedTag() = 0;

        /**
         * Function called, once this binding has been initialized.
         * @return  true, if successfully initialized, false otherwise.
         */
        virtual bool OnTargetInitialized() = 0;

    protected:

        /**
         * Retrieves the next binding in the intrinsic list linking all 
         * bindings for the same target host.
         * @return  The next binding for the same binding host.
         */
        virtual Binding* GetBindingTargetHostNext() = 0;


        /**
         * Sets the next binding in the intrinsic list linking all 
         * bindings for the same target host.
         * @param next The next binding for the same binding host.
         */
        virtual void SetBindingTargetHostNext(Binding* next) = 0;

        friend struct BindingTargetHostListAccessor;
    };

    struct BindingTargetHostListAccessor {
        static Binding* Next(Binding *binding) {
            return binding->GetBindingTargetHostNext();
        }

        static void SetNext(Binding *binding, Binding *next) {
            binding->SetBindingTargetHostNext(next);
        }
    };

} ///@}
} // namespace 

#endif // !defined(Courier_DataBinding_Binding_h)
