//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_DataBinding_AsyncTextParameterBinding_h)
#define Courier_DataBinding_AsyncTextParameterBinding_h

#include <Courier/DataBinding/AsyncBindingBase.h>

#include <Courier/DataBinding/BindableParameterCapability.h>

#if defined(CANDERA_GLOBALIZATION_ENABLED)

namespace Candera { namespace Globalization { namespace Internal {
    class ParameterizedLocalizableText;
}}}

namespace Courier { namespace Internal {
/// @addtogroup COURIER_DATABINDING
/// @{
    /**
        <summary>
           Asynchronous binding object implementation for parameterized
           localizable texts.
        </summary>
     */
    FEATSTD_LINT_CURRENT_SCOPE(1748, "the non-virtual base class 'Binding' has no members")
    class AsyncTextParameterBinding : public AsyncBindingBase {
    public:
        static const UInt16 cNameLength = 12;             ///< length of the binding target name.
        static const UInt16 cMaxParameterCount = 8;       ///< Max. number of parameters to be bound.
        static const UInt8 cInvalidParameterIndex = 0xFF; ///< Value to distinguish unset parameter indices.

        AsyncTextParameterBinding();
        virtual ~AsyncTextParameterBinding();

        /**
         * Sets the value of the bound text parameter.
         * @param   value The value to be set.
         * @return  true, if successful, false otherwise.
         */
        virtual bool SetTargetValue(const DataItemValue &value);

        /**
         * Retrieves the value of the bound text parameter.
         * @param   value The value value of the text parameter, if successful.
         * @return  true, if successful, false otherwise.
         */
        virtual bool GetTargetValue(const DataItemValue &value) const;

        /**
         * @return The name of the bound text parameter.
         */
        virtual const Char* GetTargetName() const;

        /**
         * Initializes this binding object.
         * @param bindingSource        The binding source to bind to.
         * @param itemKey              The key of the data item to bind to.
         * @param parameterIndex       The index of the parameter to bind to.
         * @param text                 The text hosting the parameter to bind to.
         * @param enableTypeConversion Whether to enable type conversion for this binding.
         * @param defaultValue         The default value to use prior to available data.
         * @return                     true, if the binding could be initialized, false otherwise.
         */
        bool Init(AsyncModelBindingSource *bindingSource,
            DataItemKey itemKey,
            UInt8 parameterIndex,
            Candera::Globalization::Internal::ParameterizedLocalizableText * text,
            bool enableTypeConversion,
            const DataItemValue &defaultValue);

    protected:
        bool CustomSetup(AsyncModelBindingSource *bindingSource, DataItemKey itemKey, UInt8 parameterIndex, Candera::Globalization::Internal::ParameterizedLocalizableText *text);
        bool SetupCapability(UInt8 parameterIndex, Candera::Globalization::Internal::ValueType parameterType);
        bool CustomInternalInit(UInt8 parameterIndex, Candera::Globalization::Internal::ParameterizedLocalizableText *text);

    private:
        BindableParameterCapabilityBase* mCapability;
        UInt8 mParameterIndex;
        Char mName[cNameLength];

        FEATSTD_MAKE_CLASS_UNCOPYABLE(AsyncTextParameterBinding);

        void InitName();
    };
///@}
}}

#endif

#endif // !defined(Courier_DataBinding_AsyncTextParameterBinding_h)
