//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_DataBinding_AsyncBinding_h)
#define Courier_DataBinding_AsyncBinding_h

#include <Courier/DataBinding/Binding.h>

namespace Courier { namespace Internal {
/// @addtogroup COURIER_DATABINDING
/// @{
    namespace DataBinding {
        namespace Async {
            class AsyncWidgetPropertyBinding;
        }
    }

    /**
     * Interface for bindings between an asynchronous binding source and a
     * binding target (e.g. widget property or text parameter).
     */
    class AsyncBinding : public Binding {
    public:

        virtual const DataBinding::Async::AsyncWidgetPropertyBinding* ToAsyncWidgetPropertyBinding() const {
            return 0;
        }

        /**
         * Handles data item messages. A data item message is a message
         * That signals changes in a data item.
         * @param   msg The message to handle.
         * @return  true if handled by this binding, false otherwise.
         */
        virtual bool OnDataItemMsg(const AbstractDataItemMsg *msg) = 0;

        /**
         * Handles a list event.
         * @param   listEvent The event to handle.
         */
        virtual void ProcessListEvent(const ListEvent &listEvent) = 0;

        /**
         * @return  The key of the bound data item.
         */
        virtual DataItemKey GetItemKey() const = 0;

        /**
         * Retrieves the value of the bound target (e.g. widget property).
         * @param   value the retrieved value.
         * @return  true, if the value could be retrieved, false otherwise.
         */
        virtual bool GetTargetValue(const DataItemValue &value) const = 0;

        /**
         * Sets the value of the bound target (e.g. widget property).
         * @param   value the value to set.
         * @return  true, if the value could be set, false otherwise.
         */
        virtual bool SetTargetValue(const DataItemValue &value) = 0;

        virtual bool SetTargetValueFrom(const AsyncBinding& /*binding*/) {
            return false;
        }

    protected:

        virtual bool IsReadOnly() const = 0;
        virtual void SetReadOnly(bool readonly) = 0;
        virtual bool IsUpdating() const = 0;
        virtual void SetUpdating(bool value) = 0;
        virtual bool IsInitialized() const = 0;
        virtual void SetInitialized(bool initialized) = 0;
        virtual void ResetTargetModifiedTag() = 0;
        virtual AsyncBinding* GetBindingSourceNext() = 0;
        virtual void SetBindingSourceNext(AsyncBinding* next) = 0;

        friend struct AsyncBindingSourceListAccessor;
        friend class UpdateFlagGuard;
    };

    struct AsyncBindingSourceListAccessor {
        static AsyncBinding* Next(AsyncBinding *binding) {
            return binding->GetBindingSourceNext();
        }

        static void SetNext(AsyncBinding *binding, AsyncBinding *next) {
            binding->SetBindingSourceNext(next);
        }
    };
///@}
}}
#endif // !defined(Courier_DataBinding_AsyncBinding_h)
