//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_WIDGETDEFAULTMETAINFO_H)
#define CANDERA_WIDGETDEFAULTMETAINFO_H

#include <CanderaWidget/WidgetBase/WidgetMetaInfo.h>

#include <Candera/System/MetaInfo/PublicMacros.h>
#include <Candera/System/MetaInfo/TypeAggregator.h>

namespace Candera {
#ifdef CANDERA_META_DESCRIPTION
    namespace Internal {
        class EventMetaInfoSetBase;
    }
#endif
    class WidgetBase;
/// @addtogroup WidgetBase
/// @{
    class WidgetDefaultMetaInfo {
    private:
        template<typename T, bool DoCreate> friend struct ::Candera::Internal::Exposer;
        template<typename T> friend class ::Candera::Internal::AIR;
        template<bool DoCreate>
        struct CMI {
            typedef WidgetBase BaseHostType;
            typedef MetaInfo::WidgetMetaInfo BaseMetaInfoType;
#ifdef CANDERA_META_DESCRIPTION
            virtual const Candera::Internal::EventMetaInfoSetBase* GetEvents() const
            {
                return 0;
            }
            class Events
            {
                static const Candera::Internal::EventMetaInfoSetBase* GetInstance()
                {
                    return 0;
                }
            };
#endif
            struct P {
            };
        };

        static MetaInfo::WidgetMetaInfo* GetMetaInfoImpl()
        {
            return 0;
        }
    };
/// @}
}    // namespace Candera
#endif // CANDERA_WIDGETDEFAULTMETAINFO_H
