//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "StringDataTypes.h"
#include <FeatStd/Diagnostics/Debug.h>

#include <FeatStd/Util/StringDataFactory.h>

#ifdef FEATSTD_THREADSAFETY_ENABLED
#include <FeatStd/Platform/CriticalSectionLocker.h>
#endif

namespace Candera { namespace MetaInfo { 
    
    namespace Internal {
        class String : public FeatStd::String {
            typedef FeatStd::String Base;
        public:
            explicit String(FeatStd::Internal::StringDataBase* stringData) : Base(stringData) {}
        };
    }

static bool GetValue1(const Char*& str, UInt& value)
{
    Int count;
    if (SerializationPlatform::ToBinary(str, value, &count) == 1) {
        FEATSTD_DEBUG_ASSERT(count > 0);
        str += count;
        str++;

        return true;
    }

    return false;
}

bool DataType<FeatStd::String>::ConvertToString(const FeatStd::String& text, Char* buf, UInt bufLen)
{
    SizeType id = text.GetId();

    if (id == 0) {
#ifdef FEATSTD_THREADSAFETY_ENABLED
        FeatStd::Internal::CriticalSectionLocker lock(text.GetCriticalSection());
#endif
        const Char* str = reinterpret_cast<const Char*>(text.GetCString());
        if (str != 0) {
            StringPlatform::Copy(buf, "0;");
            FEATSTD_DEBUG_ASSERT(bufLen >= StringPlatform::Length(str) + 3);
            StringPlatform::Copy(buf + 2, str);
        }
    }
    else {
        FEATSTD_DEBUG_ASSERT(bufLen >= 13);

        StringPlatform::Copy(buf, "1;");
        static_cast<void>(SerializationPlatform::FromBinary(buf + 2, bufLen - 3, UInt(id)));
    }

    return true;
}

bool DataType<FeatStd::String>::ConvertFromString(FeatStd::String& text, const Char* buf)
{
    bool rc = false;

    UInt type;
    if (GetValue1(buf, type)) {
        FEATSTD_DEBUG_ASSERT(*(buf - 1) == ';');
        switch (static_cast<StringDataType>(type)) {
            case StaticString:
                text = FeatStd::String(reinterpret_cast<const TChar*>(buf));
                rc = true;
                break;

            case LocalizableString:
            case ParameterizedLocalizableString:
                UInt id;
                if (GetValue1(buf, id)) {
                    if (id == 0) {
                        text = FeatStd::String(buf);
                        rc = true;
                    }
                    else {
                        FeatStd::Internal::StringDataBase* strData =
                            FeatStd::Internal::StringDataFactory::GetInstance().CreateLocalizableStringData(id, buf);
                        if (strData != 0) {
                            text = Internal::String(strData);
                            rc = true;
                        }
                    }
                }
                break;

            default:
                FEATSTD_DEBUG_FAIL();
                break;
        }
    }

    return rc;
}

}}
