//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_WIDGET_H)
#define CANDERA_WIDGET_H

#include <CanderaWidget/WidgetBase/WidgetBase.h>

#include <CanderaWidget/Widget3D/WidgetDataTypes.h>

namespace Candera {
/// @addtogroup Widget3D
/// @{
/**
 *  @brief Abstract class for Candera Widgets.
 */
class Widget : public WidgetBase
{
    public:
        /**
         *  Constructs Widget object.
         */
        Widget();

        /**
         *  Destructor
         */
        virtual ~Widget();

        /**
         *  Sets the associated node of the widget.
         *  @param node The node that is set.
         */
        void SetNode(Node *node);

        /**
         *  Retrieves the associated node of the widget.
         *  @return The associated node of the widget
         */
        Node* GetNode() const { return m_node; }

        CGI_WIDGET_RTTI_DECLARATION(Widget, WidgetBase);

        CdaWidgetDef(Widget, WidgetBase)
            CdaDescription("Candera Widget 3D Base Class")

            CdaProperties()
                CdaProperty(Node, Node*, GetNode, SetNode)
                    CdaDescription("The associated node of the widget.")
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:
        /**
         *  This is a callback function which is called after SetNode is executed.
         */
        virtual void OnNodeChanged() { }

        /**
         *  This is a callback function which is called before SetNode is executed.
         */
        virtual void OnBeforeNodeChanged() { }

    private:
        Node* m_node;
};
/// @}
}   // namespace Candera
#endif // CANDERA_WIDGET_H
