//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_WIDGET_2D_H)
    #define CANDERA_WIDGET_2D_H

#include <CanderaWidget/WidgetBase/WidgetBase.h>

#include <CanderaWidget/Widget2D/Widget2DDataTypes.h>

namespace Candera {
/// @addtogroup Widget2D
/// @{
   /**
    * @brief Base class for all Candera 2D widgets.
    *
    */
class Widget2D : public WidgetBase
{
    public:
        /**
         *  Constructor
         */
        Widget2D();

        /**
          *  Destructor
          */
        virtual ~Widget2D();

        /**
         *  Retrieves the associated node of the widget.
         *  @return The associated node of the widget.
         */
        Node2D* GetNode() const { return m_node; }

        /**
         *  Sets the associated node of the widget.
         *  @param node The associated node to which the widget is set.
         */
        void SetNode(Node2D *node);

        CGI_WIDGET_RTTI_DECLARATION(Widget2D, Candera::WidgetBase);

        CdaWidget2DDef(Candera::Widget2D, Candera::WidgetBase)
            CdaDescription("Candera Widget 2D Base Class")

            CdaProperties()
                CdaProperty(Node, Node2D*, GetNode, SetNode)
                    CdaDescription("The associated node of the widget.")
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:
        /**
         *  This is a callback function which is called after SetNode is executed.
         */
        virtual void OnNodeChanged() { }

        /**
         *  This is a callback function which is called before SetNode is executed.
         */
        virtual void OnBeforeNodeChanged() { }

#if defined(CANDERA_LAYOUT_ENABLED)
        /**
         *  Sets "SetLayoutInvalid" for the scene in which the current node is.
         */
        void InvalidateLayout() const;
#endif

    private:
        Node2D* m_node;
};
/// @}
}   // namespace Candera
#endif // CANDERA_WIDGET_2D_H
