//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Widget2D.h"
#include <Candera/Engine2D/Core/Scene2D.h>

namespace Candera {

    CGI_WIDGET_RTTI_DEFINITION(Widget2D)

    Widget2D::Widget2D() :
        m_node(0)
    {
    }

    Widget2D::~Widget2D()
    {
    }

    void Widget2D::SetNode(Node2D* node)
    {
        if (m_node != node)
        {
            OnBeforeNodeChanged();
            m_node = node;
            OnNodeChanged();
        }
    }

#if defined(CANDERA_LAYOUT_ENABLED)
    void Widget2D::InvalidateLayout() const 
    {
        AbstractNodePointer abstractNode(GetNode());
        Layouter::InvalidateLayout(abstractNode);
    }
#endif

}   // namespace Candera
