//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_TRIGGER_H)
#define CANDERA_TRIGGER_H

#include <Candera/System/MemoryManagement/SharedPointer.h>
#include <CanderaTransitions/RequestFragment.h>
#include <CanderaTransitions/Rule.h>

namespace Candera {
namespace Transitions {
    /// @addtogroup Transition
    /// @{

    class TransitionStrategy;

    /**
     * @brief Holds the rule and matching requests that were used to generate a request fragment.
     */
    class Trigger
    {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Trigger);

        const Rule::SharedPointer& GetRule() const { return m_rule; }
        const RequestFragment::SharedPointer& GetRequest() const { return m_firstRequest; }

    private:
        friend class TransitionStrategy;

        Trigger(const RequestFragment::SharedPointer& firstRequest, const Rule::SharedPointer& rule);
        RequestFragment::SharedPointer m_firstRequest;
        Rule::SharedPointer m_rule;

        CANDERA_SHARED_POINTER_DECLARATION();
    };
    /// @}
} // namespace Transitions
} // namespace Candera

#endif // CANDERA_TRIGGER_H
