//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_TRANSITION_TRACE_MAPPPER_H)
#define CANDERA_TRANSITION_TRACE_MAPPPER_H

#ifdef FEATSTD_LOG_ENABLED

#include <FeatStd/Diagnostics/Debug.h>
#include <CanderaTransitions/Transition.h>

namespace Candera {
namespace Transitions {
/// @addtogroup Transition
/// @{


/**
 *  Provides functions to retrieve certain information from transition specific classes in human readable form, useful for logging outputs.
 */
class TransitionTraceMapper {

public:
    /**
     * Function to map RequestFragment::Type enum to string.
     */
    static const Char* MapRequestFragmentTypeToString(RequestFragment::Type type) {
        static const UInt c_typeCount = RequestFragment::Finish + 1;
        FEATSTD_COMPILETIME_ASSERT(c_typeCount <= 3); //If this fails update the string array below with the added types.
        static const Char* c_types[] = {
            "Deactivate",       //0
            "Activate",         //1
            "Finish"            //2
        };
        return (type < static_cast<RequestFragment::Type>(c_typeCount)) ? c_types[type] : "Unknown Type";
    }

    /**
     *  Function to map Identifier::Type enum to string.
     */
    static const Char* MapIdentifierTypeToString(Identifier::Type type) {
        static const UInt c_typeCount = Identifier::ExternCustomIdentifier + 1;
        FEATSTD_COMPILETIME_ASSERT(c_typeCount <= 10); //If this fails update the string array below with the added types.
        static const Char* c_names[] = {
            "NoneBuiltInIdentifier",        //0
            "Scene2DBuiltInIdentifier",     //1
            "Scene3DBuiltInIdentifier",     //2
            "Node2DBuiltInIdentifier",      //3
            "Node3DBuiltInIdentifier",      //4
            "AnyScene2DBuiltInIdentifier",  //5
            "AnyScene3DBuiltInIdentifier",  //6
            "AnyNode2DBuiltInIdentifier",   //7
            "AnyNode3DBuiltInIdentifier",   //8
            "ExternCustomIdentifier"        //9
        };
        return (type < static_cast<Identifier::Type>(c_typeCount)) ? c_names[type] : "Unknown Type";
    }

    /**
     * 
     */
    static const Char* MapIdentifierToString(const Identifier& identifier) {
        return MapIdentifierTypeToString(identifier.GetType());
    }

    /**
     * 
     */
    static const Char* MapHintToString(const Hint& hint) {
        return hint.GetName().GetCString();
    }

};


/// @}
}   // namespace Transitions
}   // namespace Candera

#endif
#endif // CANDERA_TRANSITION_TRACE_MAPPPER_H
