//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_TRANSITION_H)
#define CANDERA_TRANSITION_H

#include <Candera/Environment.h>
#include <Candera/System/MemoryManagement/SharedPointer.h>

#include <CanderaTransitions/Identifier.h>
#include <CanderaTransitions/Rule.h>
#include <CanderaTransitions/Hint.h>
#include <CanderaTransitions/Request.h>
#include <CanderaTransitions/TransitionFragment.h>
#include <CanderaTransitions/TransitionFragmentFactory.h>

namespace Candera {
namespace Transitions {
/// @addtogroup Transition
/// @{

/**
 * @brief
 */
class Transition
{
public:
    FEATSTD_TYPEDEF_SHARED_POINTER(Transition);

    class Set
    {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Set);

        Set() : m_firstTransition(0) {}
        Set(const Set& set) : m_firstTransition(set.m_firstTransition) {}

        /**
         *  Get the first transition of the set.
         *  @return A shared pointer to the first transition in the set, will point to null if the set is empty.
         */
        const Transition::SharedPointer& GetFirstTransition() const { return m_firstTransition; }

        const Set& operator=(const Set& set) {
            m_firstTransition = set.m_firstTransition;
            CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1539, Candera::Transitions::Transition::Set::m_retainCount, "False positive because m_retainCount is not a member of Candera::Transitions::Transition::Set.");
            return *this;
        }

    private:
        friend class TransitionStrategy;

        Transition::SharedPointer m_firstTransition;

        CANDERA_SHARED_POINTER_DECLARATION();
    };

    /**
     *  Get the next transition in the set.
     *  @return a shared pointer to the next transition in the set.
     */
    const Transition::SharedPointer& GetNext() const { return m_nextTransition; }

    /**
     *  Get the first transition fragment in this transition.
     *  @return a shared pointer to the first transition fragment in this transition.
     */
    const TransitionFragment::SharedPointer& GetFirstFragment() const { return m_firstFragment; }

    /**
     *  Whether this transition is pending execution.
     *  @return true if the transition has not yet been executed at least once, false otherwise.
     */
    bool IsPendingExecution() const { return m_isPendingExecution; }

private:
    friend class TransitionStrategy;

    Transition();

    TransitionFragment::SharedPointer m_firstFragment;
    SharedPointer m_nextTransition;
    bool m_isPendingExecution;

    CANDERA_SHARED_POINTER_DECLARATION();
};
/// @}
}   // namespace Transitions
}   // namespace Candera

#endif // CANDERA_TRANSITION_H
