//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Rule.h"
#include <CanderaTransitions/Transition.h>
#include <CanderaTransitions/Identifier.h>
#include <CanderaTransitions/Hint.h>
#include <CanderaTransitions/TransitionFragmentFactory.h>

namespace Candera {

    using namespace Transitions;

    Rule::Rule(Identifier source, Identifier destination, Hint hint, const TransitionFragmentFactory::SharedPointer& factory, bool allowReverse, bool isBidirectional) :
        m_source(source),
        m_destination(destination),
        m_hint(hint),
        m_factory(factory),
        m_next(0),
        m_isReverseAllowed(allowReverse),
        m_isBidirectional(isBidirectional)
    {
    }

    Rule::Set::Set() :
        m_firstRule(0)
    {}

}   // namespace Candera
