//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_RULE_ADDER_H)
#define CANDERA_RULE_ADDER_H

#include <Candera/System/MemoryManagement/SharedPointer.h>
#include <CanderaTransitions/Rule.h>

namespace Candera {

namespace Transitions {

    class Identifier;
    class Hint;
    class TransitionFragmentFactory;
}   // namespace Transitions

namespace Internal {

/**
* @brief Provides functionality to build Rule sets.
*/
class RuleAdder
{
public:

    /**
     *  Begin composing a rule set. This function must be called before any rules are added.
     */
    static void BeginRuleSet();

    /**
     *  Append a rule to the current rule set. BeginRuleSet must have been called first.
     *  @
     */
    static void AddRule(Transitions::Identifier source, Transitions::Identifier destination, Transitions::Hint hint, const MemoryManagement::SharedPointer<Transitions::TransitionFragmentFactory>& factory, bool allowReverse = false, bool isBidirectional = false);

    /**
     *  @return a shared pointer to the completed rule set.
     */
    static Transitions::Rule::Set::SharedPointer EndRuleSet();
};


} //namespace Internal
}   // namespace Candera

#endif // CANDERA_RULE_ADDER_H
