//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_TRANSITION_CUSTOMIDENTIFIER_H)
#define CANDERA_TRANSITION_CUSTOMIDENTIFIER_H

#include <Candera/System/MemoryManagement/SharedPointer.h>
#include <CanderaPlatform/OS/CanderaTypes.h>

namespace Candera {

namespace Transitions {
/// @addtogroup Transition
/// @{

class Identifier;

/**
* @brief
*/
class CustomIdentifier
{
public:
    FEATSTD_TYPEDEF_SHARED_POINTER(CustomIdentifier);

    virtual bool Matches(const CustomIdentifier& identifier);

private:
    friend class Identifier;

    CANDERA_SHARED_POINTER_DECLARATION();
};


/// @}
}   // namespace Transitions
}   // namespace Candera

#endif // CANDERA_TRANSITION_H
