//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef CANDERA_SCRIPTING_SCRIPTEVENT_H
#define CANDERA_SCRIPTING_SCRIPTEVENT_H

#include <CanderaScripting/ScriptSystem.h>
#include <FeatStd/Event/Event.h>

namespace Candera {

namespace Scripting {

/** @addtogroup Scripting
 *  @{
 */

class ScriptParameters;

/**
 * @brief  ScriptEvent is a FeatStd::Event that can be dispatched and received by both scripts running
 *         in the virtual machine of the ScriptSystem, as well as native implementations of EventListeners.
 */

class ScriptEvent : public FeatStd::Event
{
public:
    /**
     *  Constructor
     *  @param scriptParameters  A container of values that is dispatched to the event listeners.
     */
    ScriptEvent(const ScriptParameters& scriptParameters);

    /**
     *  Destructor
     */
    virtual ~ScriptEvent() {}

    /**
     *  Returns the container of values that is dispatched to the event listeners.
     *  @return  the container of values that is dispatched to the event listeners.
     */
    const ScriptParameters& GetParameters() const { return m_scriptParameters; }

    FEATSTD_RTTI_DECLARATION();

private:
    FEATSTD_MAKE_CLASS_STATIC(ScriptEvent);
    FEATSTD_MAKE_CLASS_UNCOPYABLE(ScriptEvent);

    const ScriptParameters& m_scriptParameters;
};

/** @} */ // end of Scripting

} // namespace Scripting

} // namespace Candera

#endif
