//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef CANDERA_CANDERAOBJECTREFERENCESYSTEM_H
#define CANDERA_CANDERAOBJECTREFERENCESYSTEM_H

#include <Candera/System/EntityComponentSystem/ComponentSystem.h>
#include <CanderaScripting/ObjectReferenceComponent.h>

namespace Candera {

namespace EntityComponentSystem { class EntitySystem; }

namespace Scripting {

class LuaScriptSystem;
class ScriptParameters;
class ScriptSystem;

namespace Internal {

class ObjectReferenceSystem : public EntityComponentSystem::ComponentSystem<ObjectReferenceComponent, CanderaObject>
{
    typedef EntityComponentSystem::ComponentSystem<ObjectReferenceComponent, CanderaObject> Base;

public:
    /**
     *  Destructor
     */
    virtual ~ObjectReferenceSystem() {}

    FEATSTD_RTTI_DECLARATION();

private:
    /**
     *  Constructor
     */
    ObjectReferenceSystem() {};

    friend class EntityComponentSystem::EntitySystem;
    friend class Scripting::LuaScriptSystem;
    friend class Scripting::ScriptSystem;
    friend class Scripting::ScriptParameters;
};

} // namespace Internal

} // namespace Scripting

} // namespace Candera

#endif
