//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef CANDERA_SCRIPTING_LUABINDING2D_H
#define CANDERA_SCRIPTING_LUABINDING2D_H

#include <CanderaScripting/LuaScriptSystem.h>
#include <CanderaScripting/Lua/LuaBinding.h>

namespace Candera {

namespace Scripting {

namespace Internal {

/** @addtogroup LuaScripting
 *  @{
 */

/**
 * @brief  LuaBinding2D exposes Candera2D functionality in Lua. See LuaBinding for further details.
 */

class LuaBinding2D : LuaBinding
{
public:
    static void AddFunctions(lua_State* luaState);
    static void Init2D(lua_State* luaState);

private:
    FEATSTD_MAKE_CLASS_STATIC(LuaBinding2D);

    static const luaL_Reg s_additionalFunctions[];
    static const CanderaReferenceType s_canderaObjectReferenceTypes2D[];
};

/** @} */ // end of LuaScripting

} // namespace Internal

} // namespace Scripting

} // namespace Candera

#endif

