//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "LuaBinding2D.h"

#include <Candera/Engine2D/Core/BitmapImage2D.h>
#include <Candera/Engine2D/Core/Camera2D.h>
#include <Candera/Engine2D/Core/Node2D.h>

namespace Candera {

namespace Scripting {

namespace Internal {

const luaL_Reg LuaBinding2D::s_additionalFunctions[] = {    
    // 2D only functions

    { NULL, NULL } // sentinel
};

void LuaBinding2D::AddFunctions(lua_State* luaState)
{
    // expects the table to be on top of the stack to add the functions to
    luaL_setfuncs(luaState, s_additionalFunctions, 0);
}

const LuaBinding::CanderaReferenceType LuaBinding2D::s_canderaObjectReferenceTypes2D[] =
{
    { "BitmapImage2D", BitmapImage2D::GetTypeId() },
    { "Camera2D", Camera2D::GetTypeId() },
    { "Node2D", Node2D::GetTypeId() }
};

void LuaBinding2D::Init2D(lua_State* luaState)
{
    // Set relevant ObjectReference types in Candera.ReferenceType table.
    const SizeType canderaObjectReferenceTypesSize = sizeof(s_canderaObjectReferenceTypes2D) / sizeof(CanderaReferenceType);
    AddCanderaReferenceType(luaState, &(s_canderaObjectReferenceTypes2D[0]), canderaObjectReferenceTypesSize);
}

} // namespace Internal

} // namespace Scripting

} // namespace Candera
