//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <CanderaPlatform/OS/PerfCounterPlatform.h>
#include "LinuxPerfData.h"

FEATSTD_LINT_FILE(829, cstdio, "required to read platform dependent performance data")
#include <cstdio>

namespace Platform {
    using namespace Candera;

    typedef ::GenericPlatform::PerfData::PerformanceData PerformanceData;
    typedef ::GenericPlatform::PerfData::WiData WiData;
    typedef ::GenericPlatform::PerfData::CpuData CpuData;

#define OnOk(doit) if (ok) { ok = doit; }

class FileHandle
{
    public:
        FileHandle(const Char* fileName) :
            m_file(fopen(fileName, "r"))
        {
        }

        ~FileHandle()
        {
            if (m_file != 0) {
                fclose(m_file);
            }
        }

        bool IsOpen() const { return m_file != 0; }
        FILE* GetHandle() const { return m_file; }

    private:
        FILE* m_file;
};

Char* ReadLine(FileHandle& file)
{
    static Char line[1000];
    return (fgets(line, 1000, file.GetHandle()));
}

bool ReadLineValue(FileHandle& file, UInt32& val)
{
    bool ok = false;
    Char* str = ReadLine(file);

    if (str != 0) {
        while (*str != ':') {
            str++;
        }
        FEATSTD_LINT_NEXT_EXPRESSION(970, "used to read Linux specific values, harness for 64bit")
        unsigned long ulVal;
        ok = sscanf(str, ": %ld", &ulVal) > 0;
        if (ok) {
            val = static_cast<UInt32>(ulVal);
        }
    }

    return ok;
}

bool ReadLineValue2(FileHandle& file, UInt32& val1, UInt32& val2)
{
    bool ok = false;
    Char* str = ReadLine(file);

    if (str != 0) {
        while (*str != ':') {
            str++;
        }
        FEATSTD_LINT_CURRENT_SCOPE(970, "used to read Linux specific values, harness for 64bit")
        unsigned long ulVal1;
        unsigned long ulVal2;
        ok = sscanf(str, ": %ld us (%ld %%)", &ulVal1, &ulVal2) == 2;
        if (ok) {
            val1 = static_cast<UInt32>(ulVal1);
            val2 = static_cast<UInt32>(ulVal2);
        }
    }

    return ok;
}

PerformanceData PerfData::m_cached = {
    { WiData::InvalidCount, WiData::InvalidCount },
    { WiData::InvalidCount, WiData::InvalidCount },
    { CpuData::InvalidTotalTime, CpuData::InvalidWorkTime, CpuData::InvalidLoad }
};

UInt32 PerfData::m_lastUpdate = Candera::PerfCounterPlatform::Now();

bool PerfData::GetPerformanceData(PerformanceData& data)
{
    UInt32 now = Candera::PerfCounterPlatform::Now();
    UInt32 timeSpan = now - m_lastUpdate;

    if (timeSpan < 10000) {
        data = m_cached;
        return true;
    }

    m_lastUpdate = now;

    FileHandle fhProcStat("/proc/stat");

    if (!fhProcStat.IsOpen()) {
        return false;
    }

    bool ok = true;

    // CPU
    UInt32 totalTime = 0;
    UInt32 workTime = 0;

    Char* str = ReadLine(fhProcStat);
    if (str != 0) {
        FEATSTD_LINT_NEXT_EXPRESSION(970, "used to read Linux specific values, harness for 64bit")
        unsigned long val;
        for (UInt32 i = 0; (i < 7) && ok; i++) {
            while (*str != ' ') { 
                str++; 
            }

            while (*str == ' ') { 
                str++; 
            };

            ok = sscanf(str, " %ld", &val) == 1;
            totalTime += static_cast<UInt32>(val);
            if (i < 3) {
                workTime += static_cast<UInt32>(val);
            }
        }

        UInt32 totalPeriod = totalTime - m_cached.cpu.totalTime;
        UInt32 workPeriod = workTime - m_cached.cpu.workTime;
        if (totalPeriod > 0) {
            m_cached.cpu.load = static_cast<UInt8>(100U * workPeriod / totalPeriod);
        }

        m_cached.cpu.totalTime = totalTime;
        m_cached.cpu.workTime = workTime;
    }
    data = m_cached;
    return ok;
}
}    // namespace Platform
