//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Win32_PerfCounter_h)
#define Win32_PerfCounter_h

#include <Candera/Environment.h>

namespace Platform {

    struct PerfCounter {
        static Candera::UInt32 Now();

        static Candera::UInt32 Elapsed(Candera::UInt32 counter) {
            return Now() - counter;
        }

        static Candera::UInt32 Duration(Candera::UInt32 start, Candera::UInt32 end) {
            return static_cast<Candera::UInt32>(end - start);
        }

        static Candera::UInt32 ShortDuration(Candera::UInt16 start, Candera::UInt16 end);
    };

}   // namespace Platform

#endif// Win32_PerfCounter_h
